/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.jffi.AbstractNumericMethodGenerator;
import org.jruby.ext.ffi.jffi.JITSignature;

final class FastNumericMethodGenerator
extends AbstractNumericMethodGenerator {
    private static final int MAX_PARAMETERS = FastNumericMethodGenerator.getMaximumFastNumericParameters();
    private static final String[] signatures = FastNumericMethodGenerator.buildSignatures(Long.TYPE, MAX_PARAMETERS);
    private static final String[] methodNames = new String[]{"invokeN0", "invokeN1", "invokeN2", "invokeN3", "invokeN4", "invokeN5", "invokeN6"};

    FastNumericMethodGenerator() {
    }

    @Override
    String getInvokerMethodName(JITSignature signature) {
        int parameterCount = signature.getParameterCount();
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= methodNames.length) {
            return methodNames[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-long parameter count: " + parameterCount);
    }

    @Override
    String getInvokerSignature(int parameterCount) {
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= signatures.length) {
            return signatures[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-long parameter count: " + parameterCount);
    }

    @Override
    final Class getInvokerIntType() {
        return Long.TYPE;
    }

    @Override
    public boolean isSupported(JITSignature signature) {
        int parameterCount = signature.getParameterCount();
        if (!signature.getCallingConvention().equals((Object)CallingConvention.DEFAULT) || parameterCount > MAX_PARAMETERS) {
            return false;
        }
        Platform platform = Platform.getPlatform();
        if (platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return false;
        }
        if (!platform.getCPU().equals((Object)Platform.CPU.I386) && !platform.getCPU().equals((Object)Platform.CPU.X86_64)) {
            return false;
        }
        for (int i2 = 0; i2 < parameterCount; ++i2) {
            if (FastNumericMethodGenerator.isFastNumericParameter(platform, signature.getParameterType(i2))) continue;
            return false;
        }
        return FastNumericMethodGenerator.isFastNumericResult(platform, signature.getResultType());
    }

    static final int getMaximumFastNumericParameters() {
        try {
            Invoker.class.getDeclaredMethod("invokeN6", CallContext.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
            return 6;
        }
        catch (Throwable t) {
            return -1;
        }
    }

    private static boolean isFastNumericType(Platform platform, NativeType type2) {
        switch (type2) {
            case BOOL: 
            case CHAR: 
            case UCHAR: 
            case SHORT: 
            case USHORT: 
            case INT: 
            case UINT: 
            case LONG: 
            case ULONG: 
            case LONG_LONG: 
            case ULONG_LONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    static boolean isFastNumericResult(Platform platform, NativeType type2) {
        switch (type2) {
            case VOID: 
            case POINTER: 
            case STRING: 
            case TRANSIENT_STRING: {
                return true;
            }
        }
        return FastNumericMethodGenerator.isFastNumericType(platform, type2);
    }

    static boolean isFastNumericParameter(Platform platform, NativeType type2) {
        switch (type2) {
            case POINTER: 
            case STRING: 
            case TRANSIENT_STRING: 
            case BUFFER_IN: 
            case BUFFER_OUT: 
            case BUFFER_INOUT: {
                return true;
            }
        }
        return FastNumericMethodGenerator.isFastNumericType(platform, type2);
    }
}

