/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import org.apache.derby.agg.Aggregator;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;

public final class UserDefinedAggregator
implements ExecAggregator {
    private static final int FIRST_VERSION = 0;
    private Aggregator _aggregator;
    private DataTypeDescriptor _resultType;
    private boolean _eliminatedNulls;

    @Override
    public void setup(ClassFactory classFactory, String aggregateName, DataTypeDescriptor resultType) {
        try {
            this.setup(classFactory.loadApplicationClass(aggregateName), resultType);
        }
        catch (ClassNotFoundException cnfe) {
            this.logAggregatorInstantiationError(aggregateName, cnfe);
        }
    }

    private void setup(Class<?> udaClass, DataTypeDescriptor resultType) {
        String aggregateName = udaClass.getName();
        try {
            this._aggregator = (Aggregator)udaClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this._aggregator.init();
        }
        catch (InstantiationException ie) {
            this.logAggregatorInstantiationError(aggregateName, ie);
        }
        catch (IllegalAccessException iae) {
            this.logAggregatorInstantiationError(aggregateName, iae);
        }
        catch (NoSuchMethodException nsme) {
            this.logAggregatorInstantiationError(aggregateName, nsme);
        }
        catch (InvocationTargetException ite) {
            this.logAggregatorInstantiationError(aggregateName, ite);
        }
        this._resultType = resultType;
    }

    @Override
    public boolean didEliminateNulls() {
        return this._eliminatedNulls;
    }

    @Override
    public void accumulate(DataValueDescriptor addend, Object ga) throws StandardException {
        if (addend == null || addend.isNull()) {
            this._eliminatedNulls = true;
            return;
        }
        Object value = addend.getObject();
        this._aggregator.accumulate(value);
    }

    @Override
    public void merge(ExecAggregator addend) throws StandardException {
        UserDefinedAggregator other = (UserDefinedAggregator)addend;
        this._aggregator.merge(other._aggregator);
    }

    @Override
    public DataValueDescriptor getResult() throws StandardException {
        Object javaReturnValue = this._aggregator.terminate();
        if (javaReturnValue == null) {
            return null;
        }
        DataValueDescriptor dvd = this._resultType.getNull();
        dvd.setObjectForCast(javaReturnValue, true, javaReturnValue.getClass().getName());
        return dvd;
    }

    @Override
    public ExecAggregator newAggregator() {
        UserDefinedAggregator uda = new UserDefinedAggregator();
        uda.setup(this._aggregator.getClass(), this._resultType);
        return uda;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(0);
        out.writeObject(this._aggregator);
        out.writeObject(this._resultType);
        out.writeBoolean(this._eliminatedNulls);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readInt();
        this._aggregator = (Aggregator)in.readObject();
        this._resultType = (DataTypeDescriptor)in.readObject();
        this._eliminatedNulls = in.readBoolean();
    }

    @Override
    public int getTypeFormatId() {
        return 323;
    }

    private void logAggregatorInstantiationError(String aggregateName, Throwable t) {
        String errorMessage = MessageService.getTextMessage((String)"C008", (Object[])new Object[]{aggregateName, t.getMessage()});
        Monitor.getStream().println(errorMessage);
        Exception e = new Exception(errorMessage, t);
        e.printStackTrace(Monitor.getStream().getPrintWriter());
    }
}

