/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashMap;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.OptTrace;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.OptimizerPlan;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.CostEstimateImpl;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowOrderingImpl;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.util.ArrayUtil;

class OptimizerImpl
implements Optimizer {
    private LanguageConnectionContext lcc;
    private DataDictionary dDictionary;
    private int numTablesInQuery;
    private int numOptimizables;
    private JBitSet assignedTableMap;
    private OptimizableList optimizableList;
    private OptimizerPlan overridingPlan;
    private OptimizerPlan currentPlan;
    private OptimizablePredicateList predicateList;
    private JBitSet nonCorrelatedTableMap;
    private int[] proposedJoinOrder;
    private int[] bestJoinOrder;
    private int joinPosition;
    private boolean desiredJoinOrderFound;
    private static final int NO_JUMP = 0;
    private static final int READY_TO_JUMP = 1;
    private static final int JUMPING = 2;
    private static final int WALK_HIGH = 3;
    private static final int WALK_LOW = 4;
    private int permuteState;
    private int[] firstLookOrder;
    private boolean ruleBasedOptimization;
    private CostEstimateImpl outermostCostEstimate;
    private CostEstimateImpl currentCost;
    private CostEstimateImpl currentSortAvoidanceCost;
    private CostEstimateImpl bestCost;
    private long timeOptimizationStarted;
    private long currentTime;
    private boolean timeExceeded;
    private boolean noTimeout;
    private boolean useStatistics;
    private int tableLockThreshold;
    private JoinStrategy[] joinStrategies;
    private RequiredRowOrdering requiredRowOrdering;
    private boolean foundABestPlan;
    private CostEstimate sortCost;
    private RowOrdering currentRowOrdering = new RowOrderingImpl();
    private RowOrdering bestRowOrdering = new RowOrderingImpl();
    private int maxMemoryPerTable;
    private boolean reloadBestPlan;
    private HashMap<Object, int[]> savedJoinOrders;
    private double timeLimit;
    private CostEstimate finalCostEstimate;
    private boolean usingPredsPushedFromAbove;
    private boolean bestJoinOrderUsedPredsFromAbove;

    OptimizerImpl(OptimizableList optimizableList, OptimizablePredicateList predicateList, DataDictionary dDictionary, boolean ruleBasedOptimization, boolean noTimeout, boolean useStatistics, int maxMemoryPerTable, JoinStrategy[] joinStrategies, int tableLockThreshold, RequiredRowOrdering requiredRowOrdering, int numTablesInQuery, OptimizerPlan overridingPlan, LanguageConnectionContext lcc) throws StandardException {
        SanityManager.ASSERT((optimizableList != null ? 1 : 0) != 0, (String)"optimizableList is not expected to be null");
        this.outermostCostEstimate = this.getNewCostEstimate(0.0, 1.0, 1.0);
        this.currentCost = this.getNewCostEstimate(0.0, 0.0, 0.0);
        this.currentSortAvoidanceCost = this.getNewCostEstimate(0.0, 0.0, 0.0);
        this.bestCost = this.getNewCostEstimate(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        optimizableList.verifyProperties(dDictionary);
        this.numTablesInQuery = numTablesInQuery;
        this.numOptimizables = optimizableList.size();
        this.proposedJoinOrder = new int[this.numOptimizables];
        if (this.initJumpState() == 1) {
            this.firstLookOrder = new int[this.numOptimizables];
        }
        for (int i = 0; i < this.numOptimizables; ++i) {
            this.proposedJoinOrder[i] = -1;
        }
        this.bestJoinOrder = new int[this.numOptimizables];
        this.joinPosition = -1;
        this.optimizableList = optimizableList;
        this.overridingPlan = overridingPlan;
        this.predicateList = predicateList;
        this.dDictionary = dDictionary;
        this.ruleBasedOptimization = ruleBasedOptimization;
        this.noTimeout = noTimeout;
        this.maxMemoryPerTable = maxMemoryPerTable;
        this.joinStrategies = joinStrategies;
        this.tableLockThreshold = tableLockThreshold;
        this.requiredRowOrdering = requiredRowOrdering;
        this.useStatistics = useStatistics;
        this.lcc = lcc;
        this.assignedTableMap = new JBitSet(numTablesInQuery);
        this.nonCorrelatedTableMap = new JBitSet(numTablesInQuery);
        for (int tabCtr = 0; tabCtr < this.numOptimizables; ++tabCtr) {
            Optimizable curTable = optimizableList.getOptimizable(tabCtr);
            this.nonCorrelatedTableMap.or(curTable.getReferencedTableMap());
        }
        this.timeOptimizationStarted = System.currentTimeMillis();
        this.reloadBestPlan = false;
        this.savedJoinOrders = null;
        this.timeLimit = Double.MAX_VALUE;
        this.usingPredsPushedFromAbove = false;
        this.bestJoinOrderUsedPredsFromAbove = false;
        if (this.tracingIsOn()) {
            this.tracer().traceStartQueryBlock(this.timeOptimizationStarted, this.hashCode(), optimizableList);
        }
        if (overridingPlan != null) {
            int overriddenRowSourceCount;
            if (!overridingPlan.isBound()) {
                throw StandardException.newException((String)"42ZCE", (Object[])new Object[0]);
            }
            int actualRowSourceCount = optimizableList.size();
            if (actualRowSourceCount != (overriddenRowSourceCount = overridingPlan.countLeafNodes())) {
                throw StandardException.newException((String)"42ZCC", (Object[])new Object[]{overriddenRowSourceCount, actualRowSourceCount});
            }
        }
    }

    @Override
    public void prepForNextRound() {
        this.reloadBestPlan = false;
        this.bestCost = this.getNewCostEstimate(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        this.usingPredsPushedFromAbove = false;
        if (this.predicateList != null && this.predicateList.size() > 0) {
            for (int i = this.predicateList.size() - 1; i >= 0; --i) {
                if (!((Predicate)this.predicateList.getOptPredicate(i)).isScopedForPush()) continue;
                this.usingPredsPushedFromAbove = true;
                break;
            }
        }
        if (this.usingPredsPushedFromAbove) {
            this.timeOptimizationStarted = System.currentTimeMillis();
            this.timeExceeded = false;
        }
        this.desiredJoinOrderFound = false;
        this.initJumpState();
    }

    private int initJumpState() {
        this.permuteState = this.numTablesInQuery >= 6 ? 1 : 0;
        return this.permuteState;
    }

    private boolean tracingIsOn() {
        return this.lcc.optimizerTracingIsOn();
    }

    @Override
    public int getMaxMemoryPerTable() {
        return this.maxMemoryPerTable;
    }

    @Override
    public boolean getNextPermutation() throws StandardException {
        boolean alreadyCostsMore;
        if (this.numOptimizables < 1) {
            if (this.tracingIsOn()) {
                this.tracer().traceVacuous();
            }
            this.endOfRoundCleanup();
            return false;
        }
        this.optimizableList.initAccessPaths(this);
        if (!this.timeExceeded && this.numTablesInQuery > 6 && !this.noTimeout) {
            this.currentTime = System.currentTimeMillis();
            boolean bl = this.timeExceeded = (double)(this.currentTime - this.timeOptimizationStarted) > this.timeLimit;
            if (this.tracingIsOn() && this.timeExceeded) {
                this.tracer().traceTimeout(this.currentTime, this.bestCost);
            }
        }
        if (this.bestCost.isUninitialized() && this.foundABestPlan && (!this.usingPredsPushedFromAbove && !this.bestJoinOrderUsedPredsFromAbove || this.timeExceeded)) {
            if (this.permuteState != 2) {
                if (this.firstLookOrder == null) {
                    this.firstLookOrder = new int[this.numOptimizables];
                }
                System.arraycopy(this.bestJoinOrder, 0, this.firstLookOrder, 0, this.numOptimizables);
                this.permuteState = 2;
                if (this.joinPosition >= 0) {
                    this.rewindJoinOrder();
                    this.joinPosition = -1;
                }
            }
            this.timeExceeded = false;
        }
        boolean joinPosAdvanced = false;
        boolean bl = alreadyCostsMore = !this.bestCost.isUninitialized() && this.currentCost.compare(this.bestCost) > 0.0 && (this.requiredRowOrdering == null || this.currentSortAvoidanceCost.compare(this.bestCost) > 0.0);
        if (this.joinPosition < this.numOptimizables - 1 && !alreadyCostsMore && !this.timeExceeded) {
            if (this.joinPosition < 0 || this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]).getBestAccessPath().getCostEstimate() != null) {
                ++this.joinPosition;
                joinPosAdvanced = true;
                this.bestRowOrdering.copy(this.currentRowOrdering);
            }
        } else if (this.joinPosition < this.numOptimizables - 1) {
            if (this.tracingIsOn()) {
                this.tracer().traceShortCircuiting(this.timeExceeded, this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]), this.joinPosition);
            }
            this.reloadBestPlan = true;
        }
        if (this.permuteState == 2 && !joinPosAdvanced && this.joinPosition >= 0) {
            this.reloadBestPlan = true;
            this.rewindJoinOrder();
            this.permuteState = 0;
        }
        while (this.joinPosition >= 0) {
            int i;
            int nextOptimizable = this.proposedJoinOrder[this.joinPosition] + 1;
            if (this.proposedJoinOrder[this.joinPosition] >= 0) {
                this.pullOptimizableFromJoinOrder();
            }
            if (this.desiredJoinOrderFound || this.timeExceeded) {
                nextOptimizable = this.numOptimizables;
            } else if (this.permuteState == 2) {
                int idealOptimizable;
                nextOptimizable = idealOptimizable = this.firstLookOrder[this.joinPosition];
                int lookPos = this.numOptimizables;
                int lastSwappedOpt = -1;
                Optimizable nextOpt = this.optimizableList.getOptimizable(nextOptimizable);
                while (!nextOpt.legalJoinOrder(this.assignedTableMap)) {
                    if (lastSwappedOpt >= 0) {
                        this.firstLookOrder[this.joinPosition] = idealOptimizable;
                        this.firstLookOrder[lookPos] = lastSwappedOpt;
                    }
                    if (lookPos <= this.joinPosition + 1) {
                        if (this.joinPosition > 0) {
                            --this.joinPosition;
                            this.reloadBestPlan = true;
                            this.rewindJoinOrder();
                        }
                        this.permuteState = 0;
                        break;
                    }
                    this.firstLookOrder[this.joinPosition] = lastSwappedOpt = this.firstLookOrder[--lookPos];
                    this.firstLookOrder[lookPos] = idealOptimizable;
                    nextOptimizable = lastSwappedOpt;
                    nextOpt = this.optimizableList.getOptimizable(nextOptimizable);
                }
                if (this.permuteState == 0) continue;
                if (this.joinPosition == this.numOptimizables - 1) {
                    this.permuteState = 3;
                }
            } else {
                while (nextOptimizable < this.numOptimizables) {
                    boolean found = false;
                    for (int posn = 0; posn < this.joinPosition; ++posn) {
                        if (this.proposedJoinOrder[posn] != nextOptimizable) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        if (nextOptimizable < this.numOptimizables && !this.joinOrderMeetsDependencies(nextOptimizable)) {
                            SanityManager.THROWASSERT((String)("Found optimizable '" + nextOptimizable + "' in current join order even though its dependencies were NOT satisfied."));
                        }
                    } else {
                        if (nextOptimizable >= this.numOptimizables || this.joinOrderMeetsDependencies(nextOptimizable)) break;
                        if (this.tracingIsOn()) {
                            this.tracer().traceSkippingJoinOrder(nextOptimizable, this.joinPosition, ArrayUtil.copy((int[])this.proposedJoinOrder), (JBitSet)this.assignedTableMap.clone());
                        }
                        if (!this.optimizableList.optimizeJoinOrder()) {
                            if (this.tracingIsOn()) {
                                this.tracer().traceIllegalUserJoinOrder();
                            }
                            throw StandardException.newException((String)"42Y70", (Object[])new Object[0]);
                        }
                    }
                    ++nextOptimizable;
                }
            }
            if (nextOptimizable >= this.numOptimizables) {
                if (!this.optimizableList.optimizeJoinOrder()) {
                    if (!this.optimizableList.legalJoinOrder(this.numTablesInQuery)) {
                        if (this.tracingIsOn()) {
                            this.tracer().traceIllegalUserJoinOrder();
                        }
                        throw StandardException.newException((String)"42Y70", (Object[])new Object[0]);
                    }
                    if (this.tracingIsOn()) {
                        this.tracer().traceUserJoinOrderOptimized();
                    }
                    this.desiredJoinOrderFound = true;
                }
                if (this.permuteState == 1 && this.joinPosition > 0 && this.joinPosition == this.numOptimizables - 1) {
                    this.permuteState = 2;
                    double[] rc = new double[this.numOptimizables];
                    for (i = 0; i < this.numOptimizables; ++i) {
                        this.firstLookOrder[i] = i;
                        CostEstimate ce = this.optimizableList.getOptimizable(i).getBestAccessPath().getCostEstimate();
                        if (ce == null) {
                            this.permuteState = 1;
                            break;
                        }
                        rc[i] = ce.singleScanRowCount();
                    }
                    if (this.permuteState == 2) {
                        boolean doIt = false;
                        for (int i2 = 0; i2 < this.numOptimizables; ++i2) {
                            int k = i2;
                            for (int j = i2 + 1; j < this.numOptimizables; ++j) {
                                if (!(rc[j] < rc[k])) continue;
                                k = j;
                            }
                            if (k == i2) continue;
                            rc[k] = rc[i2];
                            int temp = this.firstLookOrder[i2];
                            this.firstLookOrder[i2] = this.firstLookOrder[k];
                            this.firstLookOrder[k] = temp;
                            doIt = true;
                        }
                        if (doIt) {
                            --this.joinPosition;
                            this.rewindJoinOrder();
                            continue;
                        }
                        this.permuteState = 0;
                    }
                }
                --this.joinPosition;
                if (this.joinPosition >= 0 || this.permuteState != 3) continue;
                this.joinPosition = 0;
                this.permuteState = 4;
                continue;
            }
            this.proposedJoinOrder[this.joinPosition] = nextOptimizable;
            if (this.permuteState == 4) {
                boolean finishedCycle = true;
                for (i = 0; i < this.numOptimizables; ++i) {
                    if (this.proposedJoinOrder[i] < this.firstLookOrder[i]) {
                        finishedCycle = false;
                        break;
                    }
                    if (this.proposedJoinOrder[i] > this.firstLookOrder[i]) break;
                }
                if (finishedCycle) {
                    this.proposedJoinOrder[this.joinPosition] = -1;
                    --this.joinPosition;
                    if (this.joinPosition >= 0) {
                        this.reloadBestPlan = true;
                        this.rewindJoinOrder();
                        this.joinPosition = -1;
                    }
                    this.permuteState = 1;
                    this.endOfRoundCleanup();
                    return false;
                }
            }
            this.optimizableList.getOptimizable(nextOptimizable).getBestAccessPath().setCostEstimate(null);
            if (this.tracingIsOn()) {
                this.tracer().traceJoinOrderConsideration(this.joinPosition, ArrayUtil.copy((int[])this.proposedJoinOrder), (JBitSet)this.assignedTableMap.clone());
            }
            Optimizable nextOpt = this.optimizableList.getOptimizable(nextOptimizable);
            JBitSet optMap = (JBitSet)nextOpt.getReferencedTableMap().clone();
            optMap.and(this.assignedTableMap);
            if (optMap.getFirstSetBit() != -1) {
                SanityManager.THROWASSERT((String)("Found multiple optimizables that share one or more referenced table numbers (esp: '" + String.valueOf(optMap) + "'), but that should not be the case."));
            }
            this.assignedTableMap.or(nextOpt.getReferencedTableMap());
            nextOpt.startOptimizing(this, this.currentRowOrdering);
            this.pushPredicates(this.optimizableList.getOptimizable(nextOptimizable), this.assignedTableMap);
            return true;
        }
        this.endOfRoundCleanup();
        return false;
    }

    private void rewindJoinOrder() throws StandardException {
        while (true) {
            Optimizable pullMe = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
            pullMe.pullOptPredicates(this.predicateList);
            if (this.reloadBestPlan) {
                pullMe.updateBestPlanMap((short)2, this);
            }
            this.proposedJoinOrder[this.joinPosition] = -1;
            if (this.joinPosition == 0) break;
            --this.joinPosition;
        }
        this.currentCost.setCost(0.0, 0.0, 0.0);
        this.currentSortAvoidanceCost.setCost(0.0, 0.0, 0.0);
        this.assignedTableMap.clearAll();
    }

    private void endOfRoundCleanup() throws StandardException {
        for (int i = 0; i < this.numOptimizables; ++i) {
            this.optimizableList.getOptimizable(i).updateBestPlanMap((short)0, this);
        }
    }

    private double recoverCostFromProposedJoinOrder(boolean sortAvoidance) throws StandardException {
        double recoveredCost = 0.0;
        for (int i = 0; i < this.joinPosition; ++i) {
            if (sortAvoidance) {
                recoveredCost += this.optimizableList.getOptimizable(this.proposedJoinOrder[i]).getBestSortAvoidancePath().getCostEstimate().getEstimatedCost();
                continue;
            }
            recoveredCost += this.optimizableList.getOptimizable(this.proposedJoinOrder[i]).getBestAccessPath().getCostEstimate().getEstimatedCost();
        }
        return recoveredCost;
    }

    private boolean joinOrderMeetsDependencies(int optNumber) throws StandardException {
        Optimizable nextOpt = this.optimizableList.getOptimizable(optNumber);
        return nextOpt.legalJoinOrder(this.assignedTableMap);
    }

    private void pullOptimizableFromJoinOrder() throws StandardException {
        double pullCost;
        double prevSingleScanRowCount;
        double prevRowCount;
        Optimizable pullMe = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
        int prevPosition = 0;
        if (this.joinPosition == 0) {
            prevRowCount = this.outermostCostEstimate.rowCount();
            prevSingleScanRowCount = this.outermostCostEstimate.singleScanRowCount();
        } else {
            prevPosition = this.proposedJoinOrder[this.joinPosition - 1];
            CostEstimate localCE = this.optimizableList.getOptimizable(prevPosition).getBestAccessPath().getCostEstimate();
            prevRowCount = localCE.rowCount();
            prevSingleScanRowCount = localCE.singleScanRowCount();
        }
        double newCost = this.currentCost.getEstimatedCost();
        CostEstimate pullCostEstimate = pullMe.getBestAccessPath().getCostEstimate();
        if (pullCostEstimate != null && (newCost -= (pullCost = pullCostEstimate.getEstimatedCost())) <= 0.0) {
            newCost = this.joinPosition == 0 ? 0.0 : this.recoverCostFromProposedJoinOrder(false);
        }
        if (this.joinPosition == 0) {
            newCost = this.outermostCostEstimate != null ? this.outermostCostEstimate.getEstimatedCost() : 0.0;
        }
        this.currentCost.setCost(newCost, prevRowCount, prevSingleScanRowCount);
        if (this.requiredRowOrdering != null && pullMe.considerSortAvoidancePath()) {
            double prevEstimatedCost;
            AccessPath ap = pullMe.getBestSortAvoidancePath();
            if (this.joinPosition == 0) {
                prevRowCount = this.outermostCostEstimate.rowCount();
                prevSingleScanRowCount = this.outermostCostEstimate.singleScanRowCount();
                prevEstimatedCost = this.outermostCostEstimate.getEstimatedCost();
            } else {
                CostEstimate localCE = this.optimizableList.getOptimizable(prevPosition).getBestSortAvoidancePath().getCostEstimate();
                prevRowCount = localCE.rowCount();
                prevSingleScanRowCount = localCE.singleScanRowCount();
                prevEstimatedCost = this.currentSortAvoidanceCost.getEstimatedCost() - ap.getCostEstimate().getEstimatedCost();
            }
            if (prevEstimatedCost <= 0.0) {
                prevEstimatedCost = this.joinPosition == 0 ? 0.0 : this.recoverCostFromProposedJoinOrder(true);
            }
            this.currentSortAvoidanceCost.setCost(prevEstimatedCost, prevRowCount, prevSingleScanRowCount);
            this.bestRowOrdering.removeOptimizable(pullMe.getTableNumber());
            this.bestRowOrdering.copy(this.currentRowOrdering);
        }
        pullMe.pullOptPredicates(this.predicateList);
        if (this.reloadBestPlan) {
            pullMe.updateBestPlanMap((short)2, this);
        }
        this.proposedJoinOrder[this.joinPosition] = -1;
        this.assignedTableMap.xor(pullMe.getReferencedTableMap());
    }

    void pushPredicates(Optimizable curTable, JBitSet outerTables) throws StandardException {
        int numPreds = this.predicateList.size();
        JBitSet predMap = new JBitSet(this.numTablesInQuery);
        JBitSet curTableNums = null;
        BaseTableNumbersVisitor btnVis = null;
        for (int predCtr = numPreds - 1; predCtr >= 0; --predCtr) {
            boolean pushPredNow;
            Predicate pred = (Predicate)this.predicateList.getOptPredicate(predCtr);
            if (!this.isPushable(pred)) continue;
            predMap.setTo(pred.getReferencedMap());
            for (int index = 0; index < predMap.size(); ++index) {
                if (!outerTables.get(index)) continue;
                predMap.clear(index);
            }
            predMap.and(this.nonCorrelatedTableMap);
            boolean bl = pushPredNow = predMap.getFirstSetBit() == -1;
            if (pushPredNow && pred.isScopedForPush() && this.numOptimizables > 1) {
                if (btnVis == null) {
                    curTableNums = new JBitSet(this.numTablesInQuery);
                    btnVis = new BaseTableNumbersVisitor(curTableNums);
                }
                int tNum = ((FromTable)curTable).getTableNumber();
                curTableNums.clearAll();
                btnVis.setTableMap(curTableNums);
                ((FromTable)curTable).accept(btnVis);
                if (tNum >= 0) {
                    curTableNums.set(tNum);
                }
                btnVis.setTableMap(predMap);
                pred.accept(btnVis);
                predMap.and(curTableNums);
                if (predMap.getFirstSetBit() == -1) {
                    pushPredNow = false;
                }
            }
            if (!pushPredNow || !curTable.pushOptPredicate(pred)) continue;
            this.predicateList.removeOptPredicate(predCtr);
        }
    }

    @Override
    public boolean getNextDecoratedPermutation() throws StandardException {
        boolean retval;
        double originalRowCount;
        Optimizable curOpt;
        block29: {
            OptimizerPlan candidate;
            curOpt = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
            originalRowCount = 0.0;
            do {
                retval = curOpt.nextAccessPath(this, null, this.currentRowOrdering);
                if (this.overridingPlan == null || !retval) break block29;
                if (this.currentPlan != null && this.currentPlan.countLeafNodes() == this.joinPosition + 1) {
                    retval = false;
                    break block29;
                }
                candidate = OptimizerPlan.makeRowSource(this.getTupleDescriptor(curOpt), this.dDictionary);
                if (candidate == null) {
                    retval = false;
                    break block29;
                }
                if (this.currentPlan == null) continue;
                candidate = new OptimizerPlan.Join(curOpt.getCurrentAccessPath().getJoinStrategy(), this.currentPlan, candidate);
            } while (!((OptimizerPlan)candidate).isLeftPrefixOf(this.overridingPlan));
            this.currentPlan = candidate;
        }
        if (curOpt.getBestAccessPath().getCostEstimate() != null && curOpt.getCurrentAccessPath().getCostEstimate() != null) {
            if (curOpt.getBestAccessPath().getCostEstimate().compare(curOpt.getCurrentAccessPath().getCostEstimate()) != 0.0) {
                curOpt.updateBestPlanMap((short)2, curOpt);
            } else if (curOpt.getBestAccessPath().getCostEstimate().rowCount() < curOpt.getCurrentAccessPath().getCostEstimate().rowCount()) {
                curOpt.updateBestPlanMap((short)2, curOpt);
            }
        }
        curOpt.updateBestPlanMap((short)0, curOpt);
        CostEstimate ce = curOpt.getBestAccessPath().getCostEstimate();
        if (!retval && ce != null) {
            this.currentCost.setCost(this.currentCost.getEstimatedCost() + ce.getEstimatedCost(), ce.rowCount(), ce.singleScanRowCount());
            if (curOpt.considerSortAvoidancePath() && this.requiredRowOrdering != null) {
                ce = curOpt.getBestSortAvoidancePath().getCostEstimate();
                this.currentSortAvoidanceCost.setCost(this.currentSortAvoidanceCost.getEstimatedCost() + ce.getEstimatedCost(), ce.rowCount(), ce.singleScanRowCount());
            }
            if (this.tracingIsOn()) {
                this.tracer().traceCostWithoutSortAvoidance(this.currentCost);
                if (curOpt.considerSortAvoidancePath()) {
                    this.tracer().traceCostWithSortAvoidance(this.currentSortAvoidanceCost);
                }
            }
            if (this.joinPosition == this.numOptimizables - 1) {
                if (this.tracingIsOn()) {
                    this.tracer().traceCompleteJoinOrder();
                }
                if (this.requiredRowOrdering != null) {
                    boolean gotSortCost = false;
                    if (this.sortCost == null) {
                        this.sortCost = this.newCostEstimate();
                    } else if (this.requiredRowOrdering.getSortNeeded()) {
                        if (this.bestCost.rowCount() > this.currentCost.rowCount()) {
                            this.requiredRowOrdering.estimateCost(this.bestCost.rowCount(), this.bestRowOrdering, this.sortCost);
                            double oldSortCost = this.sortCost.getEstimatedCost();
                            this.requiredRowOrdering.estimateCost(this.currentCost.rowCount(), this.bestRowOrdering, this.sortCost);
                            gotSortCost = true;
                            this.bestCost.setCost(this.bestCost.getEstimatedCost() - oldSortCost + this.sortCost.getEstimatedCost(), this.sortCost.rowCount(), this.currentCost.singleScanRowCount());
                        } else if (this.bestCost.rowCount() < this.currentCost.rowCount()) {
                            this.currentCost.setCost(this.currentCost.getEstimatedCost(), this.bestCost.rowCount(), this.currentCost.singleScanRowCount());
                        }
                    }
                    if (!gotSortCost) {
                        this.requiredRowOrdering.estimateCost(this.currentCost.rowCount(), this.bestRowOrdering, this.sortCost);
                    }
                    originalRowCount = this.currentCost.rowCount();
                    this.currentCost.setCost(this.currentCost.getEstimatedCost() + this.sortCost.getEstimatedCost(), this.sortCost.rowCount(), this.currentCost.singleScanRowCount());
                    if (this.tracingIsOn()) {
                        this.tracer().traceSortCost(this.sortCost, this.currentCost);
                    }
                }
                if (!this.foundABestPlan || this.currentCost.compare(this.bestCost) < 0.0 || this.bestCost.isUninitialized()) {
                    this.rememberBestCost(this.currentCost, 1);
                    this.reloadBestPlan = false;
                } else {
                    this.reloadBestPlan = true;
                }
                if (this.requiredRowOrdering != null) {
                    double newCost = this.currentCost.getEstimatedCost() - this.sortCost.getEstimatedCost();
                    if (newCost < 0.0) {
                        newCost = 0.0;
                    }
                    this.currentCost.setCost(newCost, originalRowCount, this.currentCost.singleScanRowCount());
                }
                if (this.requiredRowOrdering != null && curOpt.considerSortAvoidancePath() && this.requiredRowOrdering.sortRequired(this.bestRowOrdering, this.optimizableList, this.proposedJoinOrder) == 3) {
                    if (this.tracingIsOn()) {
                        this.tracer().traceCurrentPlanAvoidsSort(this.bestCost, this.currentSortAvoidanceCost);
                    }
                    if (this.currentSortAvoidanceCost.compare(this.bestCost) <= 0.0 || this.bestCost.isUninitialized()) {
                        this.rememberBestCost(this.currentSortAvoidanceCost, 2);
                    }
                }
            }
        }
        return retval;
    }

    private UniqueTupleDescriptor getTupleDescriptor(Optimizable optimizable) throws StandardException {
        if (OptimizerImpl.isTableFunction(optimizable)) {
            ProjectRestrictNode prn = (ProjectRestrictNode)optimizable;
            return ((StaticMethodCallNode)((FromVTI)prn.getChildResult()).getMethodCall()).ad;
        }
        return optimizable.getCurrentAccessPath().getConglomerateDescriptor();
    }

    static boolean isTableFunction(Optimizable optimizable) {
        if (!(optimizable instanceof ProjectRestrictNode)) {
            return false;
        }
        ResultSetNode rsn = ((ProjectRestrictNode)optimizable).getChildResult();
        if (!(rsn instanceof FromVTI)) {
            return false;
        }
        return ((FromVTI)rsn).getMethodCall() instanceof StaticMethodCallNode;
    }

    private void rememberBestCost(CostEstimate currentCost, int planType) throws StandardException {
        this.foundABestPlan = true;
        if (this.tracingIsOn()) {
            this.tracer().traceCheapestPlanSoFar(planType, currentCost);
        }
        this.bestCost.setCost(currentCost);
        if (this.bestCost.getEstimatedCost() < this.timeLimit) {
            this.timeLimit = this.bestCost.getEstimatedCost();
        }
        this.bestJoinOrderUsedPredsFromAbove = this.usingPredsPushedFromAbove;
        System.arraycopy(this.proposedJoinOrder, 0, this.bestJoinOrder, 0, this.numOptimizables);
        for (int i = 0; i < this.numOptimizables; ++i) {
            this.optimizableList.getOptimizable(this.bestJoinOrder[i]).rememberAsBest(planType, this);
        }
        if (this.requiredRowOrdering != null) {
            if (planType == 2) {
                this.requiredRowOrdering.sortNotNeeded();
            } else {
                this.requiredRowOrdering.sortNeeded();
            }
        }
        if (this.tracingIsOn()) {
            if (this.requiredRowOrdering != null) {
                this.tracer().traceSortNeededForOrdering(planType, this.requiredRowOrdering);
            }
            this.tracer().traceRememberingBestJoinOrder(this.joinPosition, ArrayUtil.copy((int[])this.bestJoinOrder), planType, currentCost, (JBitSet)this.assignedTableMap.clone());
        }
    }

    @Override
    public void costPermutation() throws StandardException {
        CostEstimate outerCost = this.joinPosition == 0 ? this.outermostCostEstimate : this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition - 1]).getBestAccessPath().getCostEstimate();
        SanityManager.ASSERT((outerCost != null ? 1 : 0) != 0, (String)"outerCost is not expected to be null");
        Optimizable optimizable = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
        if (!optimizable.feasibleJoinStrategy(this.predicateList, this)) {
            return;
        }
        optimizable.optimizeIt(this, this.predicateList, outerCost, this.currentRowOrdering);
    }

    @Override
    public void costOptimizable(Optimizable optimizable, TableDescriptor td, ConglomerateDescriptor cd, OptimizablePredicateList predList, CostEstimate outerCost) throws StandardException {
        if (!optimizable.feasibleJoinStrategy(predList, this)) {
            return;
        }
        if (this.ruleBasedOptimization) {
            this.ruleBasedCostOptimizable(optimizable, td, cd, predList, outerCost);
        } else {
            this.costBasedCostOptimizable(optimizable, td, cd, predList, outerCost);
        }
    }

    private void ruleBasedCostOptimizable(Optimizable optimizable, TableDescriptor td, ConglomerateDescriptor cd, OptimizablePredicateList predList, CostEstimate outerCost) throws StandardException {
        AccessPath bestAp = optimizable.getBestAccessPath();
        if (predList != null && predList.useful(optimizable, cd)) {
            boolean newCoveringIndex = optimizable.isCoveringIndex(cd);
            if (!bestAp.getCoveringIndexScan() || bestAp.getNonMatchingIndexScan() || newCoveringIndex) {
                bestAp.setCostEstimate(this.estimateTotalCost(predList, cd, outerCost, optimizable));
                bestAp.setConglomerateDescriptor(cd);
                bestAp.setNonMatchingIndexScan(false);
                bestAp.setCoveringIndexScan(newCoveringIndex);
                bestAp.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
                optimizable.rememberJoinStrategyAsBest(bestAp);
            }
            return;
        }
        if (optimizable.isCoveringIndex(cd)) {
            bestAp.setCostEstimate(this.estimateTotalCost(predList, cd, outerCost, optimizable));
            bestAp.setConglomerateDescriptor(cd);
            bestAp.setNonMatchingIndexScan(true);
            bestAp.setCoveringIndexScan(true);
            bestAp.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(bestAp);
            return;
        }
        if (!bestAp.getCoveringIndexScan() && bestAp.getNonMatchingIndexScan() && !cd.isIndex()) {
            bestAp.setCostEstimate(this.estimateTotalCost(predList, cd, outerCost, optimizable));
            bestAp.setConglomerateDescriptor(cd);
            bestAp.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(bestAp);
            return;
        }
        ConglomerateDescriptor bestConglomerateDescriptor = bestAp.getConglomerateDescriptor();
        if (bestConglomerateDescriptor == null) {
            bestAp.setCostEstimate(this.estimateTotalCost(predList, cd, outerCost, optimizable));
            bestAp.setConglomerateDescriptor(cd);
            bestAp.setCoveringIndexScan(false);
            bestAp.setNonMatchingIndexScan(cd.isIndex());
            bestAp.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(bestAp);
        }
    }

    private void costBasedCostOptimizable(Optimizable optimizable, TableDescriptor td, ConglomerateDescriptor cd, OptimizablePredicateList predList, CostEstimate outerCost) throws StandardException {
        CostEstimate estimatedCost = this.estimateTotalCost(predList, cd, outerCost, optimizable);
        optimizable.getCurrentAccessPath().setCostEstimate(estimatedCost);
        if (!optimizable.memoryUsageOK(estimatedCost.rowCount() / outerCost.rowCount(), this.maxMemoryPerTable)) {
            if (this.tracingIsOn()) {
                this.tracer().traceSkippingBecauseTooMuchMemory(this.maxMemoryPerTable);
            }
            return;
        }
        AccessPath ap = optimizable.getBestAccessPath();
        CostEstimate bestCostEstimate = ap.getCostEstimate();
        if (bestCostEstimate == null || bestCostEstimate.isUninitialized() || estimatedCost.compare(bestCostEstimate) < 0.0) {
            ap.setConglomerateDescriptor(cd);
            ap.setCostEstimate(estimatedCost);
            ap.setCoveringIndexScan(optimizable.isCoveringIndex(cd));
            ap.setNonMatchingIndexScan(predList == null || !predList.useful(optimizable, cd));
            ap.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(ap);
        }
        if (this.requiredRowOrdering != null && (this.joinPosition == 0 || this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition - 1]).considerSortAvoidancePath()) && this.requiredRowOrdering.sortRequired(this.currentRowOrdering, this.assignedTableMap, this.optimizableList, this.proposedJoinOrder) == 3 && ((bestCostEstimate = (ap = optimizable.getBestSortAvoidancePath()).getCostEstimate()) == null || bestCostEstimate.isUninitialized() || estimatedCost.compare(bestCostEstimate) < 0.0)) {
            ap.setConglomerateDescriptor(cd);
            ap.setCostEstimate(estimatedCost);
            ap.setCoveringIndexScan(optimizable.isCoveringIndex(cd));
            ap.setNonMatchingIndexScan(predList == null || !predList.useful(optimizable, cd));
            ap.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(ap);
            optimizable.rememberSortAvoidancePath();
            this.currentRowOrdering.copy(this.bestRowOrdering);
        }
    }

    @Override
    public void considerCost(Optimizable optimizable, OptimizablePredicateList predList, CostEstimate estimatedCost, CostEstimate outerCost) throws StandardException {
        if (!optimizable.feasibleJoinStrategy(predList, this)) {
            return;
        }
        optimizable.getCurrentAccessPath().setCostEstimate(estimatedCost);
        if (!optimizable.memoryUsageOK(estimatedCost.rowCount() / outerCost.rowCount(), this.maxMemoryPerTable)) {
            if (this.tracingIsOn()) {
                this.tracer().traceSkippingBecauseTooMuchMemory(this.maxMemoryPerTable);
            }
            return;
        }
        AccessPath ap = optimizable.getBestAccessPath();
        CostEstimate bestCostEstimate = ap.getCostEstimate();
        if (bestCostEstimate == null || bestCostEstimate.isUninitialized() || estimatedCost.compare(bestCostEstimate) <= 0.0) {
            ap.setCostEstimate(estimatedCost);
            optimizable.rememberJoinStrategyAsBest(ap);
        }
        if (this.requiredRowOrdering != null && (this.joinPosition == 0 || this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition - 1]).considerSortAvoidancePath()) && this.requiredRowOrdering.sortRequired(this.currentRowOrdering, this.assignedTableMap, this.optimizableList, this.proposedJoinOrder) == 3 && ((bestCostEstimate = (ap = optimizable.getBestSortAvoidancePath()).getCostEstimate()) == null || bestCostEstimate.isUninitialized() || estimatedCost.compare(bestCostEstimate) < 0.0)) {
            ap.setCostEstimate(estimatedCost);
            optimizable.rememberJoinStrategyAsBest(ap);
            optimizable.rememberSortAvoidancePath();
            this.currentRowOrdering.copy(this.bestRowOrdering);
        }
    }

    @Override
    public DataDictionary getDataDictionary() {
        return this.dDictionary;
    }

    @Override
    public void modifyAccessPaths() throws StandardException {
        if (this.tracingIsOn()) {
            this.tracer().traceModifyingAccessPaths(this.hashCode());
        }
        if (!this.foundABestPlan) {
            if (this.tracingIsOn()) {
                this.tracer().traceNoBestPlan();
            }
            throw StandardException.newException((String)"42Y69", (Object[])new Object[0]);
        }
        this.optimizableList.reOrder(this.bestJoinOrder);
        JBitSet outerTables = new JBitSet(this.numOptimizables);
        for (int ictr = 0; ictr < this.numOptimizables; ++ictr) {
            Optimizable optimizable = this.optimizableList.getOptimizable(ictr);
            outerTables.or(optimizable.getReferencedTableMap());
            this.pushPredicates(optimizable, outerTables);
            this.optimizableList.setOptimizable(ictr, optimizable.modifyAccessPath(outerTables));
        }
    }

    private CostEstimate newCostEstimate() {
        return new CostEstimateImpl();
    }

    @Override
    public CostEstimate getOptimizedCost() {
        return this.bestCost;
    }

    @Override
    public CostEstimate getFinalCost() {
        if (this.finalCostEstimate != null) {
            return this.finalCostEstimate;
        }
        this.finalCostEstimate = this.getNewCostEstimate(0.0, 0.0, 0.0);
        for (int i = 0; i < this.bestJoinOrder.length; ++i) {
            CostEstimate ce = this.optimizableList.getOptimizable(this.bestJoinOrder[i]).getTrulyTheBestAccessPath().getCostEstimate();
            this.finalCostEstimate.setCost(this.finalCostEstimate.getEstimatedCost() + ce.getEstimatedCost(), ce.rowCount(), ce.singleScanRowCount());
        }
        return this.finalCostEstimate;
    }

    @Override
    public void setOuterRows(double outerRows) {
        this.outermostCostEstimate.setCost(this.outermostCostEstimate.getEstimatedCost(), outerRows, this.outermostCostEstimate.singleScanRowCount());
    }

    @Override
    public int tableLockThreshold() {
        return this.tableLockThreshold;
    }

    @Override
    public int getNumberOfJoinStrategies() {
        return this.joinStrategies.length;
    }

    @Override
    public JoinStrategy getJoinStrategy(int whichStrategy) {
        if (whichStrategy < 0 || whichStrategy >= this.joinStrategies.length) {
            SanityManager.THROWASSERT((String)("whichStrategy value " + whichStrategy + " out of range - should be between 0 and " + (this.joinStrategies.length - 1)));
        }
        if (this.joinStrategies[whichStrategy] == null) {
            SanityManager.THROWASSERT((String)("Strategy " + whichStrategy + " not filled in."));
        }
        return this.joinStrategies[whichStrategy];
    }

    @Override
    public JoinStrategy getJoinStrategy(String whichStrategy) {
        JoinStrategy retval = null;
        String upperValue = StringUtil.SQLToUpperCase(whichStrategy);
        for (int i = 0; i < this.joinStrategies.length; ++i) {
            if (!upperValue.equals(this.joinStrategies[i].getName())) continue;
            retval = this.joinStrategies[i];
        }
        return retval;
    }

    @Override
    public double uniqueJoinWithOuterTable(OptimizablePredicateList predList) throws StandardException {
        double retval = -1.0;
        double numUniqueKeys = 1.0;
        double currentRows = this.currentCost.rowCount();
        if (predList != null) {
            for (int i = this.joinPosition - 1; i >= 0; --i) {
                Optimizable opt = this.optimizableList.getOptimizable(this.proposedJoinOrder[i]);
                double uniqueKeysThisOptimizable = opt.uniqueJoin(predList);
                if (!(uniqueKeysThisOptimizable > 0.0)) continue;
                numUniqueKeys *= opt.uniqueJoin(predList);
            }
        }
        if (numUniqueKeys != 1.0) {
            retval = numUniqueKeys / currentRows;
        }
        return retval;
    }

    private boolean isPushable(OptimizablePredicate pred) {
        return !pred.hasSubquery();
    }

    private CostEstimate estimateTotalCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizable optimizable) throws StandardException {
        CostEstimate resultCost = optimizable.estimateCost(predList, cd, outerCost, this, this.currentRowOrdering);
        return resultCost;
    }

    @Override
    public int getLevel() {
        return 2;
    }

    CostEstimateImpl getNewCostEstimate(double theCost, double theRowCount, double theSingleScanRowCount) {
        return new CostEstimateImpl(theCost, theRowCount, theSingleScanRowCount);
    }

    @Override
    public boolean useStatistics() {
        return this.useStatistics && this.optimizableList.useStatistics();
    }

    @Override
    public void updateBestPlanMaps(short action, Object planKey) throws StandardException {
        if (this.numOptimizables > 1) {
            int[] joinOrder = null;
            if (action == 0) {
                if (this.savedJoinOrders != null) {
                    this.savedJoinOrders.remove(planKey);
                    if (this.savedJoinOrders.isEmpty()) {
                        this.savedJoinOrders = null;
                    }
                }
            } else if (action == 1) {
                if (this.savedJoinOrders == null) {
                    this.savedJoinOrders = new HashMap();
                } else {
                    joinOrder = this.savedJoinOrders.get(planKey);
                }
                if (joinOrder == null) {
                    joinOrder = new int[this.numOptimizables];
                }
                System.arraycopy(this.bestJoinOrder, 0, joinOrder, 0, this.bestJoinOrder.length);
                this.savedJoinOrders.put(planKey, joinOrder);
            } else if (this.savedJoinOrders != null && (joinOrder = this.savedJoinOrders.get(planKey)) != null) {
                System.arraycopy(joinOrder, 0, this.bestJoinOrder, 0, joinOrder.length);
            }
        }
        for (int i = this.optimizableList.size() - 1; i >= 0; --i) {
            this.optimizableList.getOptimizable(i).updateBestPlanMap(action, planKey);
        }
    }

    void addScopedPredicatesToList(PredicateList pList, ContextManager cm) throws StandardException {
        Predicate pred;
        int i;
        if (pList == null || pList == this.predicateList) {
            return;
        }
        if (this.predicateList == null) {
            this.predicateList = new PredicateList(cm);
        }
        for (i = this.predicateList.size() - 1; i >= 0; --i) {
            pred = (Predicate)this.predicateList.getOptPredicate(i);
            if (!pred.isScopedForPush()) continue;
            this.predicateList.removeOptPredicate(i);
        }
        for (i = pList.size() - 1; i >= 0; --i) {
            pred = (Predicate)pList.getOptPredicate(i);
            if (!pred.isScopedToSourceResultSet()) continue;
            pred.clearScanFlags();
            this.predicateList.addOptPredicate(pred);
            pList.removeOptPredicate(i);
        }
    }

    private OptTrace tracer() {
        return this.lcc.getOptimizerTracer();
    }

    @Override
    public int getOptimizableCount() {
        return this.optimizableList.size();
    }

    @Override
    public Optimizable getOptimizable(int idx) {
        return this.optimizableList.getOptimizable(idx);
    }
}

