/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.lang.reflect.InvocationTargetException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInfo;
import org.apache.derby.iapi.services.loader.GeneratedByteCode;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.shared.common.error.StandardException;

public abstract class LoadedGeneratedClass
implements GeneratedClass {
    private final ClassInfo ci;
    private final int classLoaderVersion;

    public LoadedGeneratedClass(ClassFactory cf, Class jvmClass) {
        this.ci = new ClassInfo(jvmClass);
        this.classLoaderVersion = cf.getClassLoaderVersion();
    }

    @Override
    public String getName() {
        return this.ci.getClassName();
    }

    @Override
    public Object newInstance(Context context) throws StandardException {
        Throwable t;
        try {
            GeneratedByteCode ni = (GeneratedByteCode)this.ci.getNewInstance();
            ni.initFromContext(context);
            ni.setGC(this);
            ni.postConstructor();
            return ni;
        }
        catch (InstantiationException ie) {
            t = ie;
        }
        catch (IllegalAccessException iae) {
            t = iae;
        }
        catch (InvocationTargetException ite) {
            t = ite;
        }
        catch (NoSuchMethodException le) {
            t = le;
        }
        catch (LinkageError le) {
            t = le;
        }
        throw StandardException.newException((String)"XBCM2.S", (Throwable)t, (Object[])new Object[]{this.getName()});
    }

    @Override
    public final int getClassLoaderVersion() {
        return this.classLoaderVersion;
    }

    protected Class<?> getJVMClass() {
        return this.ci.getClassObject();
    }
}

