/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import net.sf.saxon.trans.XPathException;

public class PackageVersion
implements Comparable {
    public ArrayList<Integer> parts = new ArrayList();
    public String suffix;
    public static PackageVersion ZERO = new PackageVersion(new int[]{0});
    public static PackageVersion ONE_ZERO = new PackageVersion(new int[]{1, 0});
    public static PackageVersion MAX_VALUE = new PackageVersion(new int[]{Integer.MAX_VALUE});

    public PackageVersion(int[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.parts.add(new Integer(values[i]));
        }
        this.trimTrailingZeroes();
    }

    private void trimTrailingZeroes() {
        for (int i = this.parts.size() - 1; i > 0; --i) {
            if (this.parts.get(i) != 0) {
                return;
            }
            this.parts.remove(i);
        }
    }

    public PackageVersion(String s) throws XPathException {
        String original = s;
        if (s.contains("-")) {
            int i = s.indexOf(45);
            this.suffix = s.substring(i + 1);
            if (!this.isNCName(this.suffix)) {
                throw new XPathException("Illegal NCName as package-version NamePart: " + original, "XTSE0020");
            }
            s = s.substring(0, i);
        }
        if (s.equals("")) {
            throw new XPathException("No numeric component of package-version: " + original, "XTSE0020");
        }
        for (String p : s.trim().split("\\.")) {
            try {
                this.parts.add(new Integer(p));
            }
            catch (NumberFormatException e) {
                throw new XPathException("Error in package-version: " + e.getMessage(), "XTSE0020");
            }
        }
        this.trimTrailingZeroes();
    }

    public boolean isNCName(String s) {
        return s.matches("^[A-Z_a-z\\u00C0\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02ff\\u0370-\\u037d\\u037f-\\u1fff\\u200c\\u200d\\u2070-\\u218f\\u2c00-\\u2fef\\u3001-\\ud7ff\\uf900-\\ufdcf\\ufdf0-\\ufffd\\x10000-\\xEFFFF][A-Z_a-z\\u00C0\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02ff\\u0370-\\u037d\\u037f-\\u1fff\\u200c\\u200d\\u2070-\\u218f\\u2c00-\\u2fef\\u3001-\\udfff\\uf900-\\ufdcf\\ufdf0-\\ufffd\\-\\.0-9\\u00b7\\u0300-\\u036f\\u203f-\\u2040]*");
    }

    public boolean equals(Object o) {
        if (o instanceof PackageVersion) {
            PackageVersion p = (PackageVersion)o;
            if (this.parts.equals(p.parts)) {
                if (this.suffix != null) {
                    return this.suffix.equals(p.suffix);
                }
                return p.suffix == null;
            }
        }
        return false;
    }

    public int compareTo(Object o) {
        if (o instanceof PackageVersion) {
            PackageVersion pv = (PackageVersion)o;
            ArrayList<Integer> p = pv.parts;
            int extent = this.parts.size() - p.size();
            int len = Math.min(this.parts.size(), p.size());
            for (int i = 0; i < len; ++i) {
                int comp = this.parts.get(i).compareTo(p.get(i));
                if (comp == 0) continue;
                return comp;
            }
            if (extent == 0 && this.suffix != null) {
                if (pv.suffix == null) {
                    return 1;
                }
                return this.suffix.compareTo(pv.suffix);
            }
            return extent;
        }
        throw new ClassCastException("Cannot compare a PackageVersion against " + o.getClass().toString());
    }

    public String getStringValue() {
        String result = "";
        for (Integer i : this.parts) {
            result = result + "." + i;
        }
        if (this.parts.size() > 0) {
            result = result.substring(1);
        }
        if (this.suffix != null) {
            result = result + "-" + this.suffix;
        }
        return result;
    }

    public boolean isPrefix(PackageVersion v) {
        int i;
        if (v.parts.size() >= this.parts.size() && (i = 0) < this.parts.size()) {
            int comp = this.parts.get(i).compareTo(v.parts.get(i));
            return this.parts.get(i).equals(v.parts.get(i));
        }
        return false;
    }
}

