/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.SubsequenceIterator;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;

public class Subsequence
extends SystemFunctionCall
implements Callable {
    public ItemType getItemType() {
        return this.argument[0].getItemType();
    }

    public int computeSpecialProperties() {
        return this.argument[0].getSpecialProperties();
    }

    public int computeCardinality() {
        if (this.getNumberOfArguments() == 3 && Literal.isConstantOne(this.argument[2])) {
            return 24576;
        }
        return this.argument[0].getCardinality() | 0x2000;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        if (this.getNumberOfArguments() == 2 && Literal.isAtomic(this.argument[1]) && !(this.argument[0] instanceof ErrorExpression)) {
            NumericValue start = (NumericValue)((Literal)this.argument[1]).getValue();
            long intstart = (start = start.round(0)).longValue();
            if (intstart > Integer.MAX_VALUE) {
                return Literal.makeEmptySequence(this.getContainer());
            }
            if (intstart <= 0L) {
                return this.argument[0];
            }
            return new TailExpression(this.argument[0], (int)intstart);
        }
        return this;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator seq = this.argument[0].iterate(context);
        AtomicValue startVal0 = (AtomicValue)this.argument[1].evaluateItem(context);
        NumericValue startVal = (NumericValue)startVal0;
        if (this.argument.length == 2) {
            return Subsequence.subSequence(seq, startVal, null, context);
        }
        AtomicValue lengthVal0 = (AtomicValue)this.argument[2].evaluateItem(context);
        NumericValue lengthVal = (NumericValue)lengthVal0;
        return Subsequence.subSequence(seq, startVal, lengthVal, context);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return SequenceTool.toLazySequence(Subsequence.subSequence(arguments[0].iterate(), (NumericValue)arguments[1].head(), arguments.length == 2 ? null : (NumericValue)arguments[2].head(), context));
    }

    public static SequenceIterator subSequence(SequenceIterator seq, NumericValue startVal, NumericValue lengthVal, XPathContext context) throws XPathException {
        if (lengthVal == null) {
            long lstart;
            if (startVal instanceof Int64Value) {
                lstart = startVal.longValue();
                if (lstart <= 1L) {
                    return seq;
                }
            } else {
                if (startVal.isNaN()) {
                    return EmptyIterator.emptyIterator();
                }
                if ((startVal = startVal.round(0)).compareTo(Int64Value.PLUS_ONE) <= 0) {
                    return seq;
                }
                if (startVal.compareTo(Int64Value.MAX_LONG) > 0) {
                    return EmptyIterator.emptyIterator();
                }
                lstart = startVal.longValue();
            }
            if (lstart > Integer.MAX_VALUE) {
                return EmptyIterator.emptyIterator();
            }
            return TailIterator.make(seq, (int)lstart);
        }
        if (startVal instanceof Int64Value && lengthVal instanceof Int64Value) {
            long lstart = startVal.longValue();
            if (lstart > Integer.MAX_VALUE) {
                return EmptyIterator.emptyIterator();
            }
            long llength = lengthVal.longValue();
            if (llength > Integer.MAX_VALUE) {
                llength = Integer.MAX_VALUE;
            }
            if (llength < 1L) {
                return EmptyIterator.emptyIterator();
            }
            long lend = lstart + llength - 1L;
            if (lend < 1L) {
                return EmptyIterator.emptyIterator();
            }
            int start = lstart < 1L ? 1 : (int)lstart;
            return SubsequenceIterator.make(seq, start, (int)lend);
        }
        if (startVal.isNaN()) {
            return EmptyIterator.emptyIterator();
        }
        if (startVal.compareTo(Int64Value.MAX_LONG) > 0) {
            return EmptyIterator.emptyIterator();
        }
        startVal = startVal.round(0);
        if (lengthVal.isNaN()) {
            return EmptyIterator.emptyIterator();
        }
        if ((lengthVal = lengthVal.round(0)).compareTo(Int64Value.ZERO) <= 0) {
            return EmptyIterator.emptyIterator();
        }
        NumericValue rend = (NumericValue)ArithmeticExpression.compute(startVal, 0, lengthVal, context);
        if (rend.isNaN()) {
            return EmptyIterator.emptyIterator();
        }
        if ((rend = (NumericValue)ArithmeticExpression.compute(rend, 1, Int64Value.PLUS_ONE, context)).compareTo(Int64Value.ZERO) <= 0) {
            return EmptyIterator.emptyIterator();
        }
        long lstart = startVal.compareTo(Int64Value.PLUS_ONE) <= 0 ? 1L : startVal.longValue();
        if (lstart > Integer.MAX_VALUE) {
            return EmptyIterator.emptyIterator();
        }
        long lend = rend.compareTo(Int64Value.MAX_LONG) >= 0 ? Integer.MAX_VALUE : rend.longValue();
        return SubsequenceIterator.make(seq, (int)lstart, (int)lend);
    }
}

