/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.Fold;
import net.sf.saxon.functions.FoldingFunction;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public class StringJoin
extends FoldingFunction {
    private boolean returnEmptyIfEmpty;

    public void setReturnEmptyIfEmpty(boolean option) {
        this.returnEmptyIfEmpty = option;
    }

    public boolean isReturnEmptyIfEmpty() {
        return this.returnEmptyIfEmpty;
    }

    public int computeCardinality() {
        if (this.returnEmptyIfEmpty) {
            return 24576;
        }
        return 16384;
    }

    public Expression copy() {
        StringJoin sj = (StringJoin)super.copy();
        sj.returnEmptyIfEmpty = this.returnEmptyIfEmpty;
        return sj;
    }

    public boolean equals(Object o) {
        return o instanceof StringJoin && super.equals(o) && this.returnEmptyIfEmpty == ((StringJoin)o).returnEmptyIfEmpty;
    }

    public int getImplementationMethod() {
        return super.getImplementationMethod() | 0x10;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression exp2;
        Expression exp = super.optimize(visitor, contextItemType);
        if (exp instanceof StringJoin && exp != (exp2 = ((StringJoin)exp).simplifySingleton())) {
            return visitor.optimize(exp2, contextItemType);
        }
        return exp;
    }

    private Expression simplifySingleton() {
        int card = this.argument[0].getCardinality();
        if (!Cardinality.allowsMany(card)) {
            if (Cardinality.allowsZero(card)) {
                return SystemFunctionCall.makeSystemFunction("string", new Expression[]{this.argument[0]});
            }
            return this.argument[0];
        }
        return this;
    }

    public Fold getFold(XPathContext context, Sequence ... additionalArguments) throws XPathException {
        CharSequence separator = "";
        if (additionalArguments.length > 0) {
            separator = additionalArguments[0].head().getStringValueCS();
        }
        return new StringJoinFold(separator);
    }

    public void process(XPathContext context) throws XPathException {
        SequenceReceiver out = context.getReceiver();
        if (out instanceof ComplexContentOutputter) {
            out.append(StringValue.EMPTY_STRING, 0, 0);
            SequenceIterator iter = this.argument[0].iterate(context);
            Item it = iter.next();
            if (it == null) {
                return;
            }
            CharSequence first = it.getStringValueCS();
            out.characters(first, 0, 0);
            it = iter.next();
            if (it == null) {
                out.append(StringValue.EMPTY_STRING, 0, 0);
                return;
            }
            if (this.argument.length == 1) {
                out.characters(it.getStringValueCS(), 0, 0);
                while ((it = iter.next()) != null) {
                    out.characters(it.getStringValueCS(), 0, 0);
                }
            } else {
                Item sepItem = this.argument[1].evaluateItem(context);
                assert (sepItem != null);
                CharSequence sep = sepItem.getStringValueCS();
                out.characters(sep, 0, 0);
                out.characters(it.getStringValueCS(), 0, 0);
                while ((it = iter.next()) != null) {
                    out.characters(sep, 0, 0);
                    out.characters(it.getStringValueCS(), 0, 0);
                }
            }
            out.append(StringValue.EMPTY_STRING, 0, 0);
        } else {
            out.append(this.evaluateItem(context), 0, 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringJoinFold
    implements Fold {
        private int position = 0;
        private CharSequence separator;
        private FastStringBuffer data;

        public StringJoinFold(CharSequence separator) {
            this.separator = separator;
            this.data = new FastStringBuffer(64);
        }

        @Override
        public void processItem(Item item) throws XPathException {
            if (this.position == 0) {
                this.data.append(item.getStringValueCS());
                this.position = 1;
            } else {
                this.data.append(this.separator);
                this.data.append(item.getStringValueCS());
            }
        }

        @Override
        public boolean isFinished() {
            return false;
        }

        @Override
        public ZeroOrOne<StringValue> result() throws XPathException {
            if (this.position == 0 && StringJoin.this.returnEmptyIfEmpty) {
                return ZeroOrOne.empty();
            }
            return new ZeroOrOne<StringValue>(new StringValue(this.data));
        }
    }
}

