/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentUriFn
extends SystemFunctionCall
implements Callable {
    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.useContextItemAsDefault(visitor);
        return this.simplifyArguments(visitor);
    }

    @Override
    public AnyURIValue evaluateItem(XPathContext c) throws XPathException {
        NodeInfo node = (NodeInfo)this.argument[0].evaluateItem(c);
        if (node == null) {
            return null;
        }
        return DocumentUriFn.getDocumentURI(node, c);
    }

    @Override
    public ZeroOrOne<AnyURIValue> call(XPathContext context, Sequence[] arguments) throws XPathException {
        NodeInfo node = this.getDefaultArgumentNode(context, arguments, "fn:document-uri()");
        if (node == null) {
            return ZeroOrOne.empty();
        }
        return new ZeroOrOne<AnyURIValue>(DocumentUriFn.getDocumentURI(node, context));
    }

    public static AnyURIValue getDocumentURI(NodeInfo node, XPathContext c) {
        if (node.getNodeKind() == 9) {
            Controller controller = c.getController();
            assert (controller != null);
            DocumentPool pool = controller.getDocumentPool();
            String docURI = pool.getDocumentURI(node);
            if (docURI == null) {
                docURI = node.getSystemId();
            }
            if (docURI == null) {
                return null;
            }
            if ("".equals(docURI)) {
                return null;
            }
            return new AnyURIValue(docURI);
        }
        return null;
    }
}

