/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.StatefulMappingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ItemMappingIterator<F extends Item, T extends Item>
implements SequenceIterator,
LookaheadIterator,
LastPositionFinder {
    private SequenceIterator base;
    private ItemMappingFunction<F, T> action;
    private boolean oneToOne = false;

    public ItemMappingIterator(SequenceIterator base, ItemMappingFunction<F, T> action) {
        this.base = base;
        this.action = action;
    }

    public ItemMappingIterator(SequenceIterator base, ItemMappingFunction<F, T> action, boolean oneToOne) {
        this.base = base;
        this.action = action;
        this.oneToOne = oneToOne;
    }

    public void setOneToOne(boolean oneToOne) {
        this.oneToOne = oneToOne;
    }

    public boolean isOneToOne() {
        return this.oneToOne;
    }

    @Override
    public boolean hasNext() {
        return ((LookaheadIterator)this.base).hasNext();
    }

    public T next() throws XPathException {
        Item nextSource;
        T current;
        do {
            if ((nextSource = this.base.next()) != null) continue;
            return null;
        } while ((current = this.action.mapItem(nextSource)) == null);
        return current;
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public SequenceIterator getAnother() throws XPathException {
        SequenceIterator newBase = this.base.getAnother();
        ItemMappingFunction newAction = this.action instanceof StatefulMappingFunction ? (ItemMappingFunction)((Object)((StatefulMappingFunction)((Object)this.action)).getAnother()) : this.action;
        return new ItemMappingIterator<F, T>(newBase, newAction, this.oneToOne);
    }

    @Override
    public int getLength() throws XPathException {
        return ((LastPositionFinder)((Object)this.base)).getLength();
    }

    @Override
    public int getProperties() {
        if (this.oneToOne) {
            return this.base.getProperties() & 6;
        }
        return 0;
    }
}

