/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.secret.store;

import org.logstash.secret.SecretIdentifier;

public class SecretStoreException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    private SecretStoreException(String message, Throwable cause) {
        super(message, cause);
    }

    private SecretStoreException(String message) {
        super(message);
    }

    public static class InvalidConfigurationException
    extends SecretStoreException {
        private static final long serialVersionUID = 1L;

        public InvalidConfigurationException(String message) {
            super(message);
        }
    }

    public static class AlreadyExistsException
    extends SecretStoreException {
        private static final long serialVersionUID = 1L;

        public AlreadyExistsException(String message) {
            super(message);
        }
    }

    public static class AccessException
    extends SecretStoreException {
        private static final long serialVersionUID = 1L;

        public AccessException(String message, Throwable throwable) {
            super(message, throwable);
        }

        public AccessException(String message) {
            super(message);
        }
    }

    public static class ImplementationInvalidException
    extends SecretStoreException {
        private static final long serialVersionUID = 1L;

        public ImplementationInvalidException(String message, Throwable throwable) {
            super(message, throwable);
        }
    }

    public static class ImplementationNotFoundException
    extends SecretStoreException {
        private static final long serialVersionUID = 1L;

        public ImplementationNotFoundException(String message, Throwable throwable) {
            super(message, throwable);
        }
    }

    public static class UnknownException
    extends SecretStoreException {
        private static final long serialVersionUID = 1L;

        public UnknownException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class PurgeException
    extends SecretStoreException {
        private static final long serialVersionUID = 1L;

        public PurgeException(SecretIdentifier secretIdentifier, Throwable cause) {
            super(String.format("Error while trying to purge secret %s", secretIdentifier.toExternalForm()), cause);
        }
    }

    public static class PersistException
    extends SecretStoreException {
        private static final long serialVersionUID = 1L;

        public PersistException(SecretIdentifier secretIdentifier, Throwable cause) {
            super(String.format("Error while trying to store secret %s", secretIdentifier.toExternalForm()), cause);
        }
    }

    public static class LoadException
    extends SecretStoreException {
        private static final long serialVersionUID = 1L;

        public LoadException(String message, Throwable cause) {
            super(message, cause);
        }

        public LoadException(String message) {
            super(message);
        }
    }

    public static class CreateException
    extends SecretStoreException {
        private static final long serialVersionUID = 1L;

        public CreateException(String message, Throwable cause) {
            super(message, cause);
        }

        public CreateException(String message) {
            super(message);
        }
    }

    public static class ListException
    extends SecretStoreException {
        private static final long serialVersionUID = 1L;

        public ListException(Throwable cause) {
            super("Error while trying to list keys in secret store", cause);
        }
    }

    public static class RetrievalException
    extends SecretStoreException {
        private static final long serialVersionUID = 1L;

        public RetrievalException(SecretIdentifier secretIdentifier, Throwable cause) {
            super(String.format("Error while trying to retrieve secret %s", secretIdentifier.toExternalForm()), cause);
        }
    }
}

