/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.metrics.counter;

import java.util.concurrent.atomic.LongAdder;
import org.jruby.RubySymbol;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.instrument.metrics.AbstractMetric;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.MetricType;
import org.logstash.instrument.metrics.counter.CounterMetric;

public class LongCounter
extends AbstractMetric<Long>
implements CounterMetric<Long> {
    public static final LongCounter DUMMY_COUNTER = new LongCounter("dummy");
    private static final IllegalArgumentException NEGATIVE_COUNT_EXCEPTION = new IllegalArgumentException("Counters can not be incremented by negative values");
    private LongAdder longAdder = new LongAdder();

    public static LongCounter fromRubyBase(AbstractNamespacedMetricExt metric, RubySymbol key) {
        ThreadContext context = RubyUtil.RUBY.getCurrentContext();
        IRubyObject counter = metric.counter(context, (IRubyObject)key);
        counter.callMethod(context, "increment", (IRubyObject)context.runtime.newFixnum(0));
        LongCounter javaCounter = LongCounter.class.isAssignableFrom(counter.getJavaClass()) ? (LongCounter)counter.toJava(LongCounter.class) : DUMMY_COUNTER;
        return javaCounter;
    }

    public LongCounter(String name) {
        super(name);
    }

    @Override
    public MetricType getType() {
        return MetricType.COUNTER_LONG;
    }

    @Override
    public Long getValue() {
        return this.longAdder.longValue();
    }

    @Override
    public void increment() {
        this.increment(1L);
    }

    @Override
    public void increment(Long by) {
        if (by < 0L) {
            throw NEGATIVE_COUNT_EXCEPTION;
        }
        this.longAdder.add(by);
    }

    @Override
    public void increment(long by) {
        if (by < 0L) {
            throw NEGATIVE_COUNT_EXCEPTION;
        }
        this.longAdder.add(by);
    }

    public void reset() {
        this.longAdder = new LongAdder();
    }
}

