/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.common;

import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FsUtil {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static final Logger logger = LogManager.getLogger(FsUtil.class);

    private FsUtil() {
    }

    public static boolean hasFreeSpace(Path path, long size) {
        long freeSpace = path.toFile().getFreeSpace();
        if (freeSpace == 0L && IS_WINDOWS) {
            logger.warn("Cannot retrieve free space on " + path.toString() + ". This is probably a SUBST'ed drive.");
            return true;
        }
        return freeSpace >= size;
    }
}

