/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.infinispan.protostream.TagReader;
import org.infinispan.protostream.TagWriter;
import org.infinispan.protostream.UnknownFieldSet;
import org.infinispan.protostream.descriptors.WireType;
import org.infinispan.protostream.impl.ByteArrayOutputStreamEx;
import org.infinispan.protostream.impl.TagReaderImpl;
import org.infinispan.protostream.impl.TagWriterImpl;

public final class UnknownFieldSetImpl
implements UnknownFieldSet,
Externalizable {
    private Map<Integer, Deque<Object>> fields;

    private Deque<Object> getField(int tag) {
        if (tag == 0) {
            throw new IllegalArgumentException("0 is not a valid tag number");
        }
        Deque<Object> field = null;
        if (this.fields == null) {
            this.fields = new HashMap<Integer, Deque<Object>>();
        } else {
            field = this.fields.get(tag);
        }
        if (field == null) {
            field = new ArrayDeque<Object>();
            this.fields.put(tag, field);
        }
        return field;
    }

    @Override
    public boolean isEmpty() {
        return this.fields == null || this.fields.isEmpty();
    }

    @Override
    public void readAllFields(TagReader input) throws IOException {
        int tag;
        while ((tag = input.readTag()) != 0 && this.readSingleField(tag, input)) {
        }
    }

    @Override
    public boolean readSingleField(int tag, TagReader input) throws IOException {
        WireType wireType = WireType.fromTag(tag);
        switch (wireType) {
            case VARINT: {
                this.getField(tag).addLast(input.readInt64());
                return true;
            }
            case FIXED64: {
                this.getField(tag).addLast(input.readFixed64());
                return true;
            }
            case LENGTH_DELIMITED: {
                this.getField(tag).addLast(input.readByteArray());
                return true;
            }
            case START_GROUP: {
                UnknownFieldSetImpl unknownFieldSet = new UnknownFieldSetImpl();
                unknownFieldSet.readAllFields(input);
                input.checkLastTagWas(WireType.makeTag(WireType.getTagFieldNumber(tag), 4));
                this.getField(tag).addLast(unknownFieldSet);
                return true;
            }
            case END_GROUP: {
                return false;
            }
            case FIXED32: {
                this.getField(tag).addLast(input.readFixed32());
                return true;
            }
        }
        throw new IOException("Protocol message tag " + tag + " has invalid wire type " + String.valueOf((Object)wireType));
    }

    @Override
    public void putVarintField(int tag, int value) {
        if (tag == 0) {
            throw new IllegalArgumentException("0 is not a valid tag");
        }
        if (WireType.getTagWireType(tag) != 0) {
            throw new IllegalArgumentException("The tag is not a VARINT: " + tag);
        }
        this.getField(tag).addLast(value);
    }

    @Override
    public void writeTo(TagWriter output) throws IOException {
        if (this.fields != null) {
            TreeMap<Integer, Deque<Object>> sorted = new TreeMap<Integer, Deque<Object>>(this.fields);
            for (Map.Entry entry : sorted.entrySet()) {
                this.writeField((Integer)entry.getKey(), (Deque)entry.getValue(), output);
            }
            output.flush();
        }
    }

    private void writeField(int tag, Deque<?> values, TagWriter output) throws IOException {
        WireType wireType = WireType.fromTag(tag);
        int fieldNumber = WireType.getTagFieldNumber(tag);
        switch (wireType) {
            case VARINT: {
                Iterator<?> iterator = values.iterator();
                while (iterator.hasNext()) {
                    long value = (Long)iterator.next();
                    output.writeUInt64(fieldNumber, value);
                }
                break;
            }
            case FIXED32: {
                Iterator<?> iterator = values.iterator();
                while (iterator.hasNext()) {
                    int value = (Integer)iterator.next();
                    output.writeFixed32(fieldNumber, value);
                }
                break;
            }
            case FIXED64: {
                Iterator<?> iterator = values.iterator();
                while (iterator.hasNext()) {
                    long value = (Long)iterator.next();
                    output.writeFixed64(fieldNumber, value);
                }
                break;
            }
            case LENGTH_DELIMITED: {
                for (byte[] value : values) {
                    output.writeBytes(fieldNumber, value);
                }
                break;
            }
            case START_GROUP: {
                for (UnknownFieldSetImpl value : values) {
                    output.writeVarint32(tag);
                    value.writeTo(output);
                    output.writeTag(fieldNumber, 4);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Tag " + tag + " has invalid wire type " + String.valueOf((Object)wireType));
            }
        }
    }

    @Override
    public <A> A consumeTag(int tag) {
        if (tag == 0) {
            throw new IllegalArgumentException("0 is not a valid tag number");
        }
        if (WireType.getTagWireType(tag) == 4) {
            throw new IllegalArgumentException("Tag " + tag + " is an end group tag");
        }
        if (this.fields == null) {
            return null;
        }
        Deque<Object> values = this.fields.get(tag);
        if (values == null) {
            return null;
        }
        Object value = values.pollFirst();
        if (values.isEmpty()) {
            this.fields.remove(tag);
        }
        return (A)value;
    }

    @Override
    public boolean hasTag(int tag) {
        if (tag == 0) {
            throw new IllegalArgumentException("0 is not a valid tag number");
        }
        return this.fields != null && this.fields.containsKey(tag);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ByteArrayOutputStreamEx baos = new ByteArrayOutputStreamEx();
        TagWriterImpl output = TagWriterImpl.newInstance(null, baos);
        this.writeTo(output);
        output.flush();
        ByteBuffer buffer = baos.getByteBuffer();
        int off = buffer.arrayOffset();
        int len = buffer.limit() - off;
        out.writeInt(len);
        out.write(buffer.array(), off, len);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int len = in.readInt();
        byte[] bytes = new byte[len];
        in.readFully(bytes);
        this.readAllFields(TagReaderImpl.newInstance(null, bytes));
    }

    public String toString() {
        return "UnknownFieldSetImpl{fields=" + String.valueOf(this.fields) + "}";
    }
}

