/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProviderFactory;
import org.keycloak.services.clientpolicy.condition.GrantTypeCondition;

public class GrantTypeConditionFactory
extends AbstractClientPolicyConditionProviderFactory {
    public static final String PROVIDER_ID = "grant-type";
    public static final String GRANT_TYPES = "grant_types";

    public GrantTypeCondition create(KeycloakSession session) {
        return new GrantTypeCondition(session);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "The condition checks that the grant type used is one of those in the configured list.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        ArrayList<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
        GrantTypeConditionFactory.addCommonConfigProperties(configProperties);
        ProviderConfigProperty property = new ProviderConfigProperty(GRANT_TYPES, "Grant Types", "The condition evaluates to true if the current grant type is one of those in the list", "MultivaluedList", null);
        List DEFAULT_GRANT_TYPES_SUPPORTED = Stream.of("authorization_code", "implicit", "refresh_token", "password", "client_credentials").collect(Collectors.toList());
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.TOKEN_EXCHANGE_STANDARD_V2)) {
            DEFAULT_GRANT_TYPES_SUPPORTED.add("urn:ietf:params:oauth:grant-type:token-exchange");
        }
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DEVICE_FLOW)) {
            DEFAULT_GRANT_TYPES_SUPPORTED.add("urn:ietf:params:oauth:grant-type:device_code");
        }
        property.setOptions(DEFAULT_GRANT_TYPES_SUPPORTED);
        configProperties.add(property);
        return configProperties;
    }
}

