/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.utils.AcrUtils;
import org.keycloak.representations.idm.ClientPolicyConditionConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyEvent;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.ClientPolicyVote;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.context.AuthorizationRequestContext;

public class AcrCondition
extends AbstractClientPolicyConditionProvider<Configuration> {
    public AcrCondition(KeycloakSession session) {
        super(session);
    }

    public Class<Configuration> getConditionConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "any-client";
    }

    public ClientPolicyVote applyPolicy(ClientPolicyContext context) throws ClientPolicyException {
        if (context.getEvent() == ClientPolicyEvent.AUTHORIZATION_REQUEST) {
            AuthorizationRequestContext authorizationRequestContext = (AuthorizationRequestContext)context;
            if (this.containsAcr(authorizationRequestContext)) {
                authorizationRequestContext.getAuthenticationSession().setAuthNote("client-policy-requested-acr", ((Configuration)this.configuration).getAcrProperty());
                return ClientPolicyVote.YES;
            }
            return ClientPolicyVote.NO;
        }
        return ClientPolicyVote.ABSTAIN;
    }

    private boolean containsAcr(AuthorizationRequestContext context) {
        List<String> acrValues = AcrUtils.getAcrValues(context.getAuthorizationEndpointRequest().getClaims(), context.getAuthorizationEndpointRequest().getAcr(), this.session.getContext().getClient());
        return acrValues != null && !acrValues.isEmpty() && acrValues.contains(((Configuration)this.configuration).getAcrProperty());
    }

    public static class Configuration
    extends ClientPolicyConditionConfigurationRepresentation {
        @JsonProperty(value="acr-property")
        protected String acrProperty;

        public String getAcrProperty() {
            return this.acrProperty;
        }

        public void setAcrProperty(String acrProperty) {
            this.acrProperty = acrProperty;
        }
    }
}

