/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCMapper;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.provider.ProviderConfigProperty;

public class OID4VCSubjectIdMapper
extends OID4VCMapper {
    public static final String MAPPER_ID = "oid4vc-subject-id-mapper";
    public static final String ID_KEY = "subjectIdProperty";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();

    @Override
    protected List<ProviderConfigProperty> getIndividualConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public static ProtocolMapperModel create(String name, String subjectId) {
        ProtocolMapperModel mapperModel = new ProtocolMapperModel();
        mapperModel.setName(name);
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put(ID_KEY, subjectId);
        configMap.put("supportedCredentialTypes", "VerifiableCredential");
        mapperModel.setConfig(configMap);
        mapperModel.setProtocol("oid4vc");
        mapperModel.setProtocolMapper(MAPPER_ID);
        return mapperModel;
    }

    @Override
    public void setClaimsForCredential(VerifiableCredential verifiableCredential, UserSessionModel userSessionModel) {
    }

    @Override
    public void setClaimsForSubject(Map<String, Object> claims, UserSessionModel userSessionModel) {
        claims.put("id", this.mapperModel.getConfig().getOrDefault(ID_KEY, String.format("urn:uuid:%s", UUID.randomUUID())));
    }

    public String getDisplayType() {
        return "CredentialSubject ID Mapper";
    }

    public String getHelpText() {
        return "Assigns a subject ID to the credentials subject. If no specific id is configured, a randomly generated one is used.";
    }

    public ProtocolMapper create(KeycloakSession session) {
        return new OID4VCSubjectIdMapper();
    }

    public String getId() {
        return MAPPER_ID;
    }

    static {
        ProviderConfigProperty idPropertyNameConfig = new ProviderConfigProperty();
        idPropertyNameConfig.setName(ID_KEY);
        idPropertyNameConfig.setLabel("ID Property Name");
        idPropertyNameConfig.setHelpText("Name of the property to contain the id.");
        idPropertyNameConfig.setDefaultValue((Object)"id");
        idPropertyNameConfig.setType("String");
        CONFIG_PROPERTIES.add(idPropertyNameConfig);
    }
}

