/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.keybinding;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.OID4VCIssuerWellKnownProvider;
import org.keycloak.protocol.oid4vc.issuance.VCIssuanceContext;
import org.keycloak.protocol.oid4vc.issuance.VCIssuerException;
import org.keycloak.protocol.oid4vc.issuance.keybinding.AbstractProofValidator;
import org.keycloak.protocol.oid4vc.issuance.keybinding.CNonceHandler;
import org.keycloak.protocol.oid4vc.model.JwtProof;
import org.keycloak.protocol.oid4vc.model.Proof;
import org.keycloak.protocol.oid4vc.model.ProofTypeJWT;
import org.keycloak.protocol.oid4vc.model.ProofTypesSupported;
import org.keycloak.protocol.oid4vc.model.SupportedCredentialConfiguration;
import org.keycloak.representations.AccessToken;
import org.keycloak.util.JsonSerialization;

public class JwtProofValidator
extends AbstractProofValidator {
    public static final String PROOF_JWT_TYP = "openid4vci-proof+jwt";
    private static final String CRYPTOGRAPHIC_BINDING_METHOD_JWK = "jwk";

    protected JwtProofValidator(KeycloakSession keycloakSession) {
        super(keycloakSession);
    }

    @Override
    public JWK validateProof(VCIssuanceContext vcIssuanceContext) throws VCIssuerException {
        try {
            return this.validateJwtProof(vcIssuanceContext);
        }
        catch (IOException | VerificationException | JWSInputException e) {
            throw new VCIssuerException("Could not validate proof", e);
        }
    }

    private JWK validateJwtProof(VCIssuanceContext vcIssuanceContext) throws VCIssuerException, JWSInputException, VerificationException, IOException {
        Optional<Proof> optionalProof = this.getProofFromContext(vcIssuanceContext);
        if (optionalProof.isEmpty() || !(optionalProof.get() instanceof JwtProof)) {
            return null;
        }
        JwtProof proof = (JwtProof)optionalProof.get();
        this.checkCryptographicKeyBinding(vcIssuanceContext);
        JWSInput jwsInput = this.getJwsInput(proof);
        JWSHeader jwsHeader = jwsInput.getHeader();
        this.validateJwsHeader(vcIssuanceContext, jwsHeader);
        JWK jwk = Optional.ofNullable(jwsHeader.getKey()).orElseThrow(() -> new VCIssuerException("Missing binding key. Make sure provided JWT contains the jwk jwsHeader claim."));
        AccessToken proofPayload = (AccessToken)JsonSerialization.readValue((byte[])jwsInput.getContent(), AccessToken.class);
        this.validateProofPayload(vcIssuanceContext, proofPayload);
        SignatureVerifierContext signatureVerifierContext = this.getVerifier(jwk, jwsHeader.getAlgorithm().name());
        if (signatureVerifierContext == null) {
            throw new VCIssuerException("No verifier configured for " + String.valueOf(jwsHeader.getAlgorithm()));
        }
        if (!signatureVerifierContext.verify(jwsInput.getEncodedSignatureInput().getBytes(StandardCharsets.UTF_8), jwsInput.getSignature())) {
            throw new VCIssuerException("Could not verify signature of provided proof");
        }
        return jwk;
    }

    private void checkCryptographicKeyBinding(VCIssuanceContext vcIssuanceContext) {
        if (vcIssuanceContext.getCredentialConfig().getCryptographicBindingMethodsSupported() == null || !vcIssuanceContext.getCredentialConfig().getCryptographicBindingMethodsSupported().contains(CRYPTOGRAPHIC_BINDING_METHOD_JWK)) {
            throw new IllegalStateException("This SD-JWT implementation only supports jwk as cryptographic binding method");
        }
    }

    private Optional<Proof> getProofFromContext(VCIssuanceContext vcIssuanceContext) throws VCIssuerException {
        return Optional.ofNullable(vcIssuanceContext.getCredentialConfig()).map(SupportedCredentialConfiguration::getProofTypesSupported).flatMap(proofTypesSupported -> {
            Optional.ofNullable(proofTypesSupported.getJwt()).orElseThrow(() -> new VCIssuerException("SD-JWT supports only jwt proof type."));
            Proof proofObject = vcIssuanceContext.getCredentialRequest().getProof();
            if (proofObject == null) {
                throw new VCIssuerException("Credential configuration requires a proof of type: jwt");
            }
            if (!(proofObject instanceof JwtProof)) {
                throw new VCIssuerException("Wrong proof type. Expected JwtProof, but got: " + proofObject.getClass().getSimpleName());
            }
            Proof proof = proofObject;
            if (!Objects.equals(proof.getProofType(), "jwt")) {
                throw new VCIssuerException("Wrong proof type");
            }
            return Optional.of(proof);
        });
    }

    private JWSInput getJwsInput(JwtProof proof) throws JWSInputException {
        return new JWSInput(proof.getJwt());
    }

    private void validateJwsHeader(VCIssuanceContext vcIssuanceContext, JWSHeader jwsHeader) throws VCIssuerException {
        Optional.ofNullable(jwsHeader.getAlgorithm()).orElseThrow(() -> new VCIssuerException("Missing jwsHeader claim alg"));
        Optional.ofNullable(vcIssuanceContext.getCredentialConfig()).map(SupportedCredentialConfiguration::getProofTypesSupported).map(ProofTypesSupported::getJwt).map(ProofTypeJWT::getProofSigningAlgValuesSupported).filter(supportedAlgs -> supportedAlgs.contains(jwsHeader.getAlgorithm().name())).orElseThrow(() -> new VCIssuerException("Proof signature algorithm not supported: " + jwsHeader.getAlgorithm().name()));
        Optional.ofNullable(jwsHeader.getType()).filter(type -> Objects.equals(PROOF_JWT_TYP, type)).orElseThrow(() -> new VCIssuerException("JWT type must be: openid4vci-proof+jwt"));
        Optional.ofNullable(jwsHeader.getKeyId()).ifPresent(keyId -> {
            throw new VCIssuerException("KeyId not expected in this JWT. Use the jwk claim instead.");
        });
    }

    private void validateProofPayload(VCIssuanceContext vcIssuanceContext, AccessToken proofPayload) throws VCIssuerException, VerificationException {
        String credentialIssuer = OID4VCIssuerWellKnownProvider.getIssuer(this.keycloakSession.getContext());
        Optional.ofNullable(proofPayload.getAudience()).map(Arrays::asList).filter(audiences -> audiences.contains(credentialIssuer)).orElseThrow(() -> new VCIssuerException("Proof not produced for this audience. Audience claim must be: " + credentialIssuer + " but are " + String.valueOf(Arrays.asList(proofPayload.getAudience()))));
        Optional.ofNullable(proofPayload.getIat()).orElseThrow(() -> new VCIssuerException("Missing proof issuing time. iat claim must be provided."));
        KeycloakContext keycloakContext = this.keycloakSession.getContext();
        CNonceHandler cNonceHandler = (CNonceHandler)this.keycloakSession.getProvider(CNonceHandler.class);
        cNonceHandler.verifyCNonce(proofPayload.getNonce(), List.of(OID4VCIssuerWellKnownProvider.getCredentialsEndpoint(keycloakContext)), Map.of("source_endpoint", OID4VCIssuerWellKnownProvider.getNonceEndpoint(keycloakContext)));
    }
}

