/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cookie;

import jakarta.ws.rs.core.UriInfo;
import org.keycloak.cookie.CookieType;
import org.keycloak.models.KeycloakContext;
import org.keycloak.services.resources.RealmsResource;

class CookiePathResolver {
    private final KeycloakContext context;
    private String realmPath;
    private String requestPath;

    CookiePathResolver(KeycloakContext context) {
        this.context = context;
    }

    String resolvePath(CookieType cookieType) {
        switch (cookieType.getPath()) {
            case REALM: {
                if (this.realmPath == null) {
                    this.realmPath = RealmsResource.realmBaseUrl((UriInfo)this.context.getUri()).path("/").build(new Object[]{this.context.getRealm().getName()}).getRawPath();
                }
                return this.realmPath;
            }
            case REQUEST: {
                if (this.requestPath == null) {
                    this.requestPath = this.context.getUri().getRequestUri().getRawPath();
                }
                return this.requestPath;
            }
        }
        throw new IllegalArgumentException("Unsupported enum value " + cookieType.getPath().name());
    }
}

