/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class WriterOutputStream
extends OutputStream {
    public static final int BUFFER_SIZE = 128;
    private final Charset charset;
    private final HttpServerExchange exchange;
    private final PrintWriter writer;
    private final CharsetDecoder encoder;

    public WriterOutputStream(HttpServerExchange exchange, PrintWriter writer, String charset) {
        this.exchange = exchange;
        this.writer = writer;
        this.charset = Charset.forName(charset);
        this.encoder = this.charset.newDecoder();
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] b) throws IOException {
        CharBuffer res = this.encoder.decode(ByteBuffer.wrap(b));
        this.writer.write(res.toString());
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        CharBuffer res = this.encoder.decode(ByteBuffer.wrap(b, off, len));
        this.writer.write(res.toString());
    }
}

