/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jboss.logmanager.ConfiguratorFactory;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextConfigurator;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.StandardOutputStreams;
import org.jboss.logmanager.configuration.PropertyLogContextConfigurator;

public final class LogManager
extends java.util.logging.LogManager {
    private final AtomicReference<LogContextConfigurator> configuratorRef = new AtomicReference();

    @Override
    public void readConfiguration() {
        this.doConfigure(null);
    }

    @Override
    public void readConfiguration(InputStream inputStream) {
        Assert.checkNotNullParam((String)"inputStream", (Object)inputStream);
        this.doConfigure(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConfigure(InputStream inputStream) {
        AtomicReference<LogContextConfigurator> configuratorRef = this.configuratorRef;
        LogContextConfigurator configurator = configuratorRef.get();
        if (configurator == null) {
            AtomicReference<LogContextConfigurator> atomicReference = configuratorRef;
            synchronized (atomicReference) {
                configurator = configuratorRef.get();
                if (configurator == null) {
                    int best = Integer.MAX_VALUE;
                    ConfiguratorFactory factory = null;
                    ServiceLoader<ConfiguratorFactory> serviceLoader = ServiceLoader.load(ConfiguratorFactory.class, LogManager.class.getClassLoader());
                    Iterator<ConfiguratorFactory> iterator = serviceLoader.iterator();
                    ArrayList<Throwable> problems = null;
                    while (true) {
                        try {
                            while (iterator.hasNext()) {
                                ConfiguratorFactory f = iterator.next();
                                if (f.priority() >= best && factory != null) continue;
                                best = f.priority();
                                factory = f;
                            }
                        }
                        catch (Throwable t) {
                            if (problems == null) {
                                problems = new ArrayList<Throwable>(4);
                            }
                            problems.add(t);
                            continue;
                        }
                        break;
                    }
                    LogContextConfigurator logContextConfigurator = configurator = factory == null ? null : factory.create();
                    if (configurator == null) {
                        if (problems == null) {
                            configurator = new PropertyLogContextConfigurator();
                            configuratorRef.set(configurator);
                        } else {
                            ServiceConfigurationError e = new ServiceConfigurationError("Failed to configure log configurator service");
                            for (Throwable problem : problems) {
                                e.addSuppressed(problem);
                            }
                            throw e;
                        }
                    }
                }
            }
        }
        configurator.configure(LogContext.getSystemLogContext(), inputStream);
    }

    @Override
    public void updateConfiguration(Function<String, BiFunction<String, String, String>> mapper) throws IOException {
    }

    @Override
    public void updateConfiguration(InputStream ins, Function<String, BiFunction<String, String, String>> mapper) throws IOException {
    }

    @Override
    public java.util.logging.LogManager addConfigurationListener(Runnable listener) {
        return this;
    }

    @Override
    public void removeConfigurationListener(Runnable listener) {
    }

    @Override
    public String getProperty(String name) {
        return null;
    }

    @Override
    public void reset() {
    }

    @Override
    public Enumeration<String> getLoggerNames() {
        return LogContext.getLogContext().getLoggerNames();
    }

    @Override
    public boolean addLogger(java.util.logging.Logger logger) {
        return false;
    }

    @Override
    public Logger getLogger(String name) {
        return LogContext.getLogContext().getLogger(name);
    }

    static {
        if (System.getSecurityManager() == null) {
            try {
                Class.forName(StandardOutputStreams.class.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Class.forName(StandardOutputStreams.class.getName());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
    }

    public static final class Provider {
        public static LogManager provider() {
            Thread ct = Thread.currentThread();
            ClassLoader old = ct.getContextClassLoader();
            ct.setContextClassLoader(Provider.class.getClassLoader());
            try {
                System.setProperty("java.util.logging.manager", LogManager.class.getName());
                LogManager logManager = (LogManager)java.util.logging.LogManager.getLogManager();
                return logManager;
            }
            finally {
                ct.setContextClassLoader(old);
            }
        }
    }
}

