/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.EventLoop;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.Http2ServerRequest;
import io.vertx.core.http.impl.Http2ServerResponse;
import io.vertx.core.http.impl.Http2ServerStream;
import io.vertx.core.http.impl.Http2ServerStreamHandler;
import io.vertx.core.http.impl.HttpServerConnection;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class Http2ServerConnection
extends Http2ConnectionBase
implements HttpServerConnection {
    final HttpServerOptions options;
    private final String serverOrigin;
    private final HttpServerMetrics metrics;
    private final Function<String, String> encodingDetector;
    private final Supplier<ContextInternal> streamContextSupplier;
    Handler<HttpServerRequest> requestHandler;
    private int concurrentStreams;
    private final ArrayDeque<Push> pendingPushes = new ArrayDeque(8);

    Http2ServerConnection(ContextInternal context, Supplier<ContextInternal> streamContextSupplier, String serverOrigin, VertxHttp2ConnectionHandler connHandler, Function<String, String> encodingDetector, HttpServerOptions options, HttpServerMetrics metrics) {
        super(context, connHandler);
        this.options = options;
        this.serverOrigin = serverOrigin;
        this.encodingDetector = encodingDetector;
        this.streamContextSupplier = streamContextSupplier;
        this.metrics = metrics;
    }

    @Override
    public HttpServerConnection handler(Handler<HttpServerRequest> handler) {
        this.requestHandler = handler;
        return this;
    }

    @Override
    public HttpServerConnection invalidRequestHandler(Handler<HttpServerRequest> handler) {
        return this;
    }

    @Override
    public HttpServerMetrics metrics() {
        return this.metrics;
    }

    private static boolean isMalformedRequest(Http2ServerStream request) {
        if (request.method == null) {
            return true;
        }
        if (request.method == HttpMethod.CONNECT ? request.scheme != null || request.uri != null || request.authority == null : request.scheme == null || request.uri == null || request.uri.length() == 0) {
            return true;
        }
        if (request.hasAuthority) {
            if (request.authority == null) {
                return true;
            }
            CharSequence hostHeader = (CharSequence)request.headers.get((Object)HttpHeaders.HOST);
            if (hostHeader != null) {
                HostAndPort host = HostAndPort.parseAuthority(hostHeader.toString(), -1);
                return host == null || !request.authority.host().equals(host.host()) || request.authority.port() != host.port();
            }
        }
        return false;
    }

    String determineContentEncoding(Http2Headers headers) {
        String acceptEncoding;
        String string = acceptEncoding = headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING) != null ? ((CharSequence)headers.get((Object)HttpHeaderNames.ACCEPT_ENCODING)).toString() : null;
        if (acceptEncoding != null && this.encodingDetector != null) {
            return this.encodingDetector.apply(acceptEncoding);
        }
        return null;
    }

    private Http2ServerStream createStream(Http2Headers headers, boolean streamEnded) {
        CharSequence schemeHeader = (CharSequence)headers.getAndRemove((Object)HttpHeaders.PSEUDO_SCHEME);
        HostAndPort authority = null;
        CharSequence authorityHeader = (CharSequence)headers.getAndRemove((Object)HttpHeaders.PSEUDO_AUTHORITY);
        if (authorityHeader != null) {
            String authorityHeaderAsString = authorityHeader.toString();
            authority = HostAndPort.parseAuthority(authorityHeaderAsString, -1);
        }
        CharSequence hostHeader = null;
        if (authority == null && (hostHeader = (CharSequence)headers.getAndRemove((Object)HttpHeaders.HOST)) != null) {
            authority = HostAndPort.parseAuthority(hostHeader.toString(), -1);
        }
        CharSequence pathHeader = (CharSequence)headers.getAndRemove((Object)HttpHeaders.PSEUDO_PATH);
        CharSequence methodHeader = (CharSequence)headers.getAndRemove((Object)HttpHeaders.PSEUDO_METHOD);
        return new Http2ServerStream(this, this.streamContextSupplier.get(), headers, schemeHeader != null ? schemeHeader.toString() : null, authorityHeader != null || hostHeader != null, authority, methodHeader != null ? HttpMethod.valueOf(methodHeader.toString()) : null, pathHeader != null ? pathHeader.toString() : null, this.options.getTracingPolicy(), streamEnded);
    }

    private void initStream(int streamId, Http2ServerStream vertxStream) {
        String contentEncoding = this.options.isCompressionSupported() ? this.determineContentEncoding(vertxStream.headers) : null;
        Http2ServerRequest request = new Http2ServerRequest(vertxStream, this.serverOrigin, vertxStream.headers, contentEncoding);
        vertxStream.request = request;
        vertxStream.isConnect = request.method() == HttpMethod.CONNECT;
        Http2Stream stream = this.handler.connection().stream(streamId);
        vertxStream.init(stream);
    }

    @Override
    protected synchronized void onHeadersRead(int streamId, Http2Headers headers, StreamPriority streamPriority, boolean endOfStream) {
        Http2ServerStream stream;
        Http2Stream nettyStream = this.handler.connection().stream(streamId);
        if (nettyStream.getProperty(this.streamKey) == null) {
            stream = streamId == 1 && this.handler.upgraded ? this.createStream(headers, true) : this.createStream(headers, endOfStream);
            if (Http2ServerConnection.isMalformedRequest(stream)) {
                this.handler.writeReset(streamId, Http2Error.PROTOCOL_ERROR.code());
                return;
            }
            this.initStream(streamId, stream);
            stream.onHeaders(headers, streamPriority);
        } else {
            stream = (Http2ServerStream)nettyStream.getProperty(this.streamKey);
        }
        if (endOfStream) {
            stream.onEnd();
        }
    }

    void sendPush(int streamId, HostAndPort authority, HttpMethod method, MultiMap headers, String path, StreamPriority streamPriority, Promise<HttpServerResponse> promise) {
        EventLoop eventLoop = this.context.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            this.doSendPush(streamId, authority, method, headers, path, streamPriority, promise);
        } else {
            eventLoop.execute(() -> this.doSendPush(streamId, authority, method, headers, path, streamPriority, promise));
        }
    }

    private synchronized void doSendPush(int streamId, HostAndPort authority, HttpMethod method, MultiMap headers, String path, StreamPriority streamPriority, Promise<HttpServerResponse> promise) {
        boolean ssl = this.isSsl();
        DefaultHttp2Headers headers_ = new DefaultHttp2Headers();
        headers_.method((CharSequence)method.name());
        headers_.path((CharSequence)path);
        headers_.scheme((CharSequence)(ssl ? "https" : "http"));
        if (authority != null) {
            String s = ssl && authority.port() == 443 || !ssl && authority.port() == 80 || authority.port() <= 0 ? authority.host() : authority.host() + ':' + authority.port();
            headers_.authority((CharSequence)s);
        }
        if (headers != null) {
            headers.forEach(arg_0 -> Http2ServerConnection.lambda$doSendPush$1((Http2Headers)headers_, arg_0));
        }
        Future<Integer> fut = this.handler.writePushPromise(streamId, (Http2Headers)headers_);
        fut.addListener((GenericFutureListener)((FutureListener)arg_0 -> this.lambda$doSendPush$2((Http2Headers)headers_, method, path, promise, streamPriority, arg_0)));
    }

    @Override
    protected void updateSettings(Http2Settings settingsUpdate, Handler<AsyncResult<Void>> completionHandler) {
        settingsUpdate.remove('\u0002');
        super.updateSettings(settingsUpdate, completionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$doSendPush$2(Http2Headers headers_, HttpMethod method, String path, Promise promise, StreamPriority streamPriority, Future future) throws Exception {
        if (future.isSuccess()) {
            Http2ServerConnection http2ServerConnection = this;
            synchronized (http2ServerConnection) {
                int promisedStreamId = (Integer)future.getNow();
                String contentEncoding = this.determineContentEncoding(headers_);
                Http2Stream promisedStream = this.handler.connection().stream(promisedStreamId);
                Http2ServerStream vertxStream = new Http2ServerStream(this, this.context, method, path, this.options.getTracingPolicy(), true);
                Push push = new Push(vertxStream, contentEncoding, promise);
                vertxStream.request = push;
                push.stream.priority(streamPriority);
                push.stream.init(promisedStream);
                int maxConcurrentStreams = this.handler.maxConcurrentStreams();
                if (this.concurrentStreams < maxConcurrentStreams) {
                    ++this.concurrentStreams;
                    push.complete();
                } else {
                    this.pendingPushes.add(push);
                }
            }
        } else {
            promise.fail(future.cause());
        }
    }

    private static /* synthetic */ void lambda$doSendPush$1(Http2Headers headers_, Map.Entry header) {
        Http2Headers cfr_ignored_0 = (Http2Headers)headers_.add(header.getKey(), header.getValue());
    }

    private class Push
    implements Http2ServerStreamHandler {
        protected final ContextInternal context;
        protected final Http2ServerStream stream;
        protected final Http2ServerResponse response;
        private final Promise<HttpServerResponse> promise;

        public Push(Http2ServerStream stream, String contentEncoding, Promise<HttpServerResponse> promise) {
            this.context = stream.context;
            this.stream = stream;
            this.response = new Http2ServerResponse((Http2ServerConnection)stream.conn, stream, true, contentEncoding);
            this.promise = promise;
        }

        @Override
        public Http2ServerResponse response() {
            return this.response;
        }

        @Override
        public void dispatch(Handler<HttpServerRequest> handler) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void handleReset(long errorCode) {
            if (!this.promise.tryFail(new StreamResetException(errorCode))) {
                this.response.handleReset(errorCode);
            }
        }

        @Override
        public void handleException(Throwable cause) {
            if (this.response != null) {
                this.response.handleException(cause);
            }
        }

        @Override
        public void handleClose() {
            if (Http2ServerConnection.this.pendingPushes.remove(this)) {
                this.promise.fail("Push reset by client");
            } else {
                Http2ServerConnection.this.concurrentStreams--;
                int maxConcurrentStreams = Http2ServerConnection.this.handler.maxConcurrentStreams();
                while (Http2ServerConnection.this.concurrentStreams < maxConcurrentStreams && Http2ServerConnection.this.pendingPushes.size() > 0) {
                    Push push = (Push)Http2ServerConnection.this.pendingPushes.pop();
                    Http2ServerConnection.this.concurrentStreams++;
                    push.complete();
                }
                this.response.handleClose();
            }
        }

        void complete() {
            this.stream.registerMetrics();
            this.promise.complete(this.response);
        }
    }

    private static class EncodingDetector
    extends HttpContentCompressor {
        private EncodingDetector(CompressionOptions[] compressionOptions) {
            super(compressionOptions);
        }

        protected String determineEncoding(String acceptEncoding) {
            return super.determineEncoding(acceptEncoding);
        }
    }
}

