/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx;

import io.vertx.core.Context;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.core.tracing.TracingPolicy;
import java.util.function.BiConsumer;
import org.jboss.logging.Logger;

public class OpenTelemetryVertxTracingFactory
implements VertxTracerFactory {
    private final VertxDelegator vertxTracerDelegator = new VertxDelegator();

    public VertxDelegator getVertxTracerDelegator() {
        return this.vertxTracerDelegator;
    }

    public VertxTracer<?, ?> tracer(TracingOptions options) {
        return this.vertxTracerDelegator;
    }

    public static class VertxDelegator
    implements VertxTracer {
        private static final Logger log = Logger.getLogger(VertxDelegator.class);
        private VertxTracer delegate;

        public VertxTracer getDelegate() {
            return this.delegate;
        }

        public VertxDelegator setDelegate(VertxTracer delegate) {
            this.delegate = delegate;
            return this;
        }

        public Object receiveRequest(Context context, SpanKind kind, TracingPolicy policy, Object request, String operation, Iterable headers, TagExtractor tagExtractor) {
            if (this.delegate == null) {
                log.warnv("VertxTracer delegate not set. Will not submit this trace. SpanKind: {0}; Request: {1}; Operation:{2}.", (Object)kind, (Object)(request == null ? "null" : request.toString()), (Object)operation);
                return null;
            }
            return this.delegate.receiveRequest(context, kind, policy, request, operation, headers, tagExtractor);
        }

        public void sendResponse(Context context, Object response, Object payload, Throwable failure, TagExtractor tagExtractor) {
            if (this.delegate == null) {
                log.warnv("VertxTracer delegate not set. Will not submit this trace. Response: {0}; Failure: {1}.", (Object)(response == null ? "null" : response.toString()), (Object)(failure == null ? "null" : failure.getMessage()));
                return;
            }
            this.delegate.sendResponse(context, response, payload, failure, tagExtractor);
        }

        public Object sendRequest(Context context, SpanKind kind, TracingPolicy policy, Object request, String operation, BiConsumer headers, TagExtractor tagExtractor) {
            if (this.delegate == null) {
                log.warnv("VertxTracer delegate not set. Will not submit this trace. SpanKind: {0}; Request: {1}; Operation:{2}.", (Object)kind, (Object)(request == null ? "null" : request.toString()), (Object)operation);
                return null;
            }
            return this.delegate.sendRequest(context, kind, policy, request, operation, headers, tagExtractor);
        }

        public void receiveResponse(Context context, Object response, Object payload, Throwable failure, TagExtractor tagExtractor) {
            if (this.delegate == null) {
                log.warnv("VertxTracer delegate not set. Will not submit this trace. Response: {0}; Failure: {1}.", (Object)(response == null ? "null" : response.toString()), (Object)(failure == null ? "null" : failure.getMessage()));
                return;
            }
            this.delegate.receiveResponse(context, response, payload, failure, tagExtractor);
        }
    }
}

