/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.txoj.recovery;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreAPI;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.txoj.recovery.RecoveredTransactionalObject;
import com.arjuna.ats.txoj.logging.txojLogger;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class TORecoveryModule
implements RecoveryModule {
    private Hashtable _uncommittedTOTable;
    private static ObjectStoreAPI _objectStore = null;

    public TORecoveryModule() {
        if (txojLogger.logger.isDebugEnabled()) {
            txojLogger.logger.debug((Object)"TORecoveryModule created");
        }
        _objectStore = StoreManager.getTxOJStore();
    }

    @Override
    public void periodicWorkFirstPass() {
        block12: {
            if (txojLogger.logger.isDebugEnabled()) {
                txojLogger.logger.debug((Object)"TORecoveryModule - first pass");
            }
            this._uncommittedTOTable = new Hashtable();
            try {
                InputObjectState types = new InputObjectState();
                if (!_objectStore.allTypes(types)) break block12;
                String theName = null;
                try {
                    boolean endOfList = false;
                    while (!endOfList) {
                        theName = types.unpackString();
                        if (theName.compareTo("") == 0) {
                            endOfList = true;
                            continue;
                        }
                        InputObjectState uids = new InputObjectState();
                        if (!_objectStore.allObjUids(theName, uids, 2)) continue;
                        Uid theUid = null;
                        try {
                            boolean endOfUids = false;
                            while (!endOfUids) {
                                theUid = UidHelper.unpackFrom(uids);
                                if (theUid.equals(Uid.nullUid())) {
                                    endOfUids = true;
                                    continue;
                                }
                                String newTypeString = new String(theName);
                                Uid newUid = new Uid(theUid);
                                this._uncommittedTOTable.put(newUid, newTypeString);
                                if (!txojLogger.logger.isDebugEnabled()) continue;
                                txojLogger.logger.debug((Object)("TO currently uncommitted " + String.valueOf(newUid) + " is a " + newTypeString));
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                catch (IOException endOfList) {
                }
                catch (Exception e) {
                    txojLogger.i18NLogger.warn_recovery_TORecoveryModule_5(e);
                }
            }
            catch (Exception e) {
                txojLogger.i18NLogger.warn_recovery_TORecoveryModule_5(e);
            }
        }
    }

    @Override
    public void periodicWorkSecondPass() {
        if (txojLogger.logger.isDebugEnabled()) {
            txojLogger.logger.debug((Object)"TORecoveryModule - second pass");
        }
        Enumeration uncommittedObjects = this._uncommittedTOTable.keys();
        while (uncommittedObjects.hasMoreElements()) {
            Uid objUid = (Uid)uncommittedObjects.nextElement();
            String objType = (String)this._uncommittedTOTable.get(objUid);
            try {
                if (_objectStore.currentState(objUid, objType) == 2) {
                    this.recoverObject(objUid, objType);
                    continue;
                }
                if (!txojLogger.logger.isDebugEnabled()) continue;
                txojLogger.logger.debug((Object)("Object (" + String.valueOf(objUid) + ", " + objType + ") is no longer uncommitted."));
            }
            catch (ObjectStoreException ose) {
                if (!txojLogger.logger.isDebugEnabled()) continue;
                txojLogger.logger.debug((Object)("Object (" + String.valueOf(objUid) + ", " + objType + ") no longer exists."));
            }
        }
    }

    protected void initialise() {
        if (txojLogger.logger.isDebugEnabled()) {
            txojLogger.logger.debug((Object)"TORecoveryModule.initialise()");
        }
    }

    private final void recoverObject(Uid objUid, String objType) {
        if (txojLogger.logger.isDebugEnabled()) {
            txojLogger.logger.debug((Object)("TORecoveryModule.recoverObject(" + String.valueOf(objUid) + ", " + objType + ")"));
        }
        RecoveredTransactionalObject recoveredTO = new RecoveredTransactionalObject(objUid, objType, _objectStore);
        recoveredTO.replayPhase2();
    }
}

