/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev.console;

import io.quarkus.dev.console.QuarkusConsole;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Formatter;
import java.util.Locale;

public class RedirectPrintStream
extends PrintStream {
    private Formatter formatter;
    private final boolean errorStream;

    public RedirectPrintStream(boolean errorStream) {
        super(new ByteArrayOutputStream(0));
        this.errorStream = errorStream;
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        QuarkusConsole.INSTANCE.write(this.errorStream, buf, off, len);
    }

    void write(String s) {
        QuarkusConsole.INSTANCE.write(this.errorStream, s);
    }

    @Override
    public void write(int b) {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] buf) {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void writeBytes(byte[] buf) {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void print(boolean b) {
        this.write(String.valueOf(b));
    }

    @Override
    public void print(char c) {
        this.write(String.valueOf(c));
    }

    @Override
    public void print(int i) {
        this.write(String.valueOf(i));
    }

    @Override
    public void print(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.write(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.write(String.valueOf(d));
    }

    @Override
    public void print(char[] s) {
        this.write(String.valueOf(s));
    }

    @Override
    public void print(String s) {
        this.write(String.valueOf(s));
    }

    @Override
    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    @Override
    public void println() {
        this.write("\n");
    }

    @Override
    public void println(boolean x) {
        this.write(String.valueOf(x) + "\n");
    }

    @Override
    public void println(char x) {
        this.write(String.valueOf(x) + "\n");
    }

    @Override
    public void println(int x) {
        this.write(String.valueOf(x) + "\n");
    }

    @Override
    public void println(long x) {
        this.write(String.valueOf(x) + "\n");
    }

    @Override
    public void println(float x) {
        this.write(String.valueOf(x) + "\n");
    }

    @Override
    public void println(double x) {
        this.write(String.valueOf(x) + "\n");
    }

    @Override
    public void println(char[] x) {
        this.write(String.valueOf(x) + "\n");
    }

    @Override
    public void println(String x) {
        this.write(String.valueOf(x) + "\n");
    }

    @Override
    public void println(Object x) {
        this.write(String.valueOf(x) + "\n");
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        return this.format(format, args);
    }

    @Override
    public PrintStream printf(Locale l, String format, Object ... args) {
        return this.format(l, format, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintStream format(String format, Object ... args) {
        RedirectPrintStream redirectPrintStream = this;
        synchronized (redirectPrintStream) {
            if (this.formatter == null || this.formatter.locale() != Locale.getDefault(Locale.Category.FORMAT)) {
                this.formatter = new Formatter((Appendable)this);
            }
            this.formatter.format(Locale.getDefault(Locale.Category.FORMAT), format, args);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrintStream format(Locale l, String format, Object ... args) {
        RedirectPrintStream redirectPrintStream = this;
        synchronized (redirectPrintStream) {
            if (this.formatter == null || this.formatter.locale() != l) {
                this.formatter = new Formatter(this, l);
            }
            this.formatter.format(l, format, args);
        }
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq) {
        this.print(String.valueOf(csq));
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        if (csq == null) {
            csq = "null";
        }
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public PrintStream append(char c) {
        this.print(c);
        return this;
    }
}

