/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.Consumer;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.tty.Signal;

public class EventDecoder
implements Consumer<int[]> {
    private final int intr;
    private final int susp;
    private final int eof;
    private Consumer<Signal> signalHandler;
    private Consumer<int[]> inputHandler;
    private Queue<int[]> inputQueue = new ArrayDeque<int[]>(10);

    public EventDecoder() {
        this.intr = 3;
        this.eof = 4;
        this.susp = 26;
    }

    public EventDecoder(int intr, int eof, int susp) {
        this.intr = intr;
        this.eof = eof;
        this.susp = susp;
    }

    public EventDecoder(Attributes attributes) {
        this.intr = attributes.getControlChar(Attributes.ControlChar.VINTR) > 0 ? attributes.getControlChar(Attributes.ControlChar.VINTR) : 3;
        this.eof = attributes.getControlChar(Attributes.ControlChar.VEOF) > 0 ? attributes.getControlChar(Attributes.ControlChar.VEOF) : 4;
        this.susp = attributes.getControlChar(Attributes.ControlChar.VSUSP) > 0 ? attributes.getControlChar(Attributes.ControlChar.VSUSP) : 26;
    }

    public Consumer<Signal> getSignalHandler() {
        return this.signalHandler;
    }

    public void setSignalHandler(Consumer<Signal> signalHandler) {
        this.signalHandler = signalHandler;
    }

    public Consumer<int[]> getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(Consumer<int[]> inputHandler) {
        this.inputHandler = inputHandler;
        this.checkQueue();
    }

    private void checkQueue() {
        while (this.inputHandler != null && !this.inputQueue.isEmpty()) {
            this.inputHandler.accept(this.inputQueue.poll());
        }
    }

    @Override
    public void accept(int[] input) {
        if (this.signalHandler != null) {
            int index = 0;
            while (index < input.length) {
                int val = input[index];
                Signal event = null;
                if (val == this.intr) {
                    event = Signal.INT;
                } else if (val == this.susp) {
                    event = Signal.SUSP;
                } else if (val == this.eof) {
                    event = Signal.EOF;
                }
                if (event != null && this.signalHandler != null) {
                    int[] a;
                    if (this.inputHandler != null) {
                        a = new int[index];
                        if (index > 0) {
                            System.arraycopy(input, 0, a, 0, index);
                            this.inputHandler.accept(a);
                        }
                    }
                    this.signalHandler.accept(event);
                    a = new int[input.length - index - 1];
                    System.arraycopy(input, index + 1, a, 0, a.length);
                    input = a;
                    index = 0;
                    continue;
                }
                ++index;
            }
        }
        if (input.length > 0) {
            if (this.inputHandler != null) {
                this.inputHandler.accept(input);
            } else {
                this.inputQueue.add(input);
            }
        }
    }
}

