/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import io.quarkus.paths.ArchivePathTree;
import io.quarkus.paths.DirectoryPathTree;
import io.quarkus.paths.FilePathTree;
import io.quarkus.paths.PathFilter;
import io.quarkus.paths.PathTree;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class PathTreeBuilder {
    private boolean archive;
    private Boolean manifestEnabled;
    private Path root;
    private List<String> includes;
    private List<String> excludes;

    public PathTreeBuilder setArchive(boolean archive) {
        this.archive = archive;
        return this;
    }

    public PathTreeBuilder setManifestEnabled(boolean manifestEnabled) {
        this.manifestEnabled = manifestEnabled;
        return this;
    }

    public PathTreeBuilder setRoot(Path root) {
        this.root = root;
        return this;
    }

    Path getRoot() {
        return this.root;
    }

    public PathTreeBuilder include(String expr) {
        if (this.includes == null) {
            this.includes = new ArrayList<String>(1);
        }
        this.includes.add(expr);
        return this;
    }

    List<String> getIncludes() {
        return this.includes;
    }

    public PathTreeBuilder exclude(String expr) {
        if (this.excludes == null) {
            this.excludes = new ArrayList<String>(1);
        }
        this.excludes.add(expr);
        return this;
    }

    List<String> getExcludes() {
        return this.includes;
    }

    PathFilter getPathFilter() {
        return this.includes == null && this.excludes == null ? null : new PathFilter(this.includes, this.excludes);
    }

    public PathTree build() {
        if (this.root == null) {
            throw new RuntimeException("The tree root has not been provided");
        }
        if (!Files.exists(this.root, new LinkOption[0])) {
            throw new IllegalArgumentException(String.valueOf(this.root) + " does not exist");
        }
        if (this.archive) {
            return ArchivePathTree.forPath(this.root, this.getPathFilter(), this.manifestEnabled == null ? true : this.manifestEnabled);
        }
        if (Files.isDirectory(this.root, new LinkOption[0])) {
            return new DirectoryPathTree(this.root, this.getPathFilter(), this.manifestEnabled == null ? false : this.manifestEnabled);
        }
        return new FilePathTree(this.root, this.getPathFilter());
    }
}

