/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ManifestAttributes {
    private String specificationTitle;
    private String specificationVersion;
    private String specificationVendor;
    private String implementationTitle;
    private String implementationVersion;
    private String implementationVendor;
    private boolean multiRelease;

    public static ManifestAttributes of(Manifest manifest) {
        if (manifest == null) {
            return null;
        }
        return new ManifestAttributes(manifest);
    }

    private ManifestAttributes(Manifest manifest) {
        this.specificationTitle = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_TITLE);
        this.specificationVersion = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
        this.specificationVendor = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VENDOR);
        this.implementationTitle = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        this.implementationVersion = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        this.implementationVendor = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        this.multiRelease = Boolean.parseBoolean(manifest.getMainAttributes().getValue(Attributes.Name.MULTI_RELEASE));
    }

    public String getSpecificationTitle() {
        return this.specificationTitle;
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    public String getSpecificationVendor() {
        return this.specificationVendor;
    }

    public String getImplementationTitle() {
        return this.implementationTitle;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public String getImplementationVendor() {
        return this.implementationVendor;
    }

    public boolean isMultiRelease() {
        return this.multiRelease;
    }
}

