/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.organization;

import org.keycloak.Config;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.infinispan.organization.InfinispanOrganizationProvider;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.OrganizationProviderFactory;

public class InfinispanOrganizationProviderFactory
implements OrganizationProviderFactory {
    public static final String PROVIDER_ID = "infinispan";

    public OrganizationProvider create(KeycloakSession session) {
        return new InfinispanOrganizationProvider(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(e -> {
            RealmModel.IdentityProviderUpdatedEvent event;
            if (e instanceof RealmModel.IdentityProviderUpdatedEvent) {
                event = (RealmModel.IdentityProviderUpdatedEvent)e;
                this.registerOrganizationInvalidation(event.getKeycloakSession(), event.getUpdatedIdentityProvider());
            }
            if (e instanceof RealmModel.IdentityProviderRemovedEvent) {
                event = (RealmModel.IdentityProviderRemovedEvent)e;
                this.registerOrganizationInvalidation(event.getKeycloakSession(), event.getRemovedIdentityProvider());
            }
            if (e instanceof UserModel.UserPreRemovedEvent) {
                event = (UserModel.UserPreRemovedEvent)e;
                KeycloakSession session = event.getKeycloakSession();
                InfinispanOrganizationProvider orgProvider = (InfinispanOrganizationProvider)session.getProvider(OrganizationProvider.class, this.getId());
                orgProvider.getByMember(event.getUser()).forEach(arg_0 -> InfinispanOrganizationProviderFactory.lambda$postInit$0(orgProvider, (UserModel.UserPreRemovedEvent)event, arg_0));
            }
        });
    }

    private void registerOrganizationInvalidation(KeycloakSession session, IdentityProviderModel idp) {
        InfinispanOrganizationProvider orgProvider;
        if (idp.getOrganizationId() != null && (orgProvider = (InfinispanOrganizationProvider)session.getProvider(OrganizationProvider.class, this.getId())) != null) {
            OrganizationModel organization = orgProvider.getById(idp.getOrganizationId());
            orgProvider.registerOrganizationInvalidation(organization);
        }
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public int order() {
        return 10;
    }

    private static /* synthetic */ void lambda$postInit$0(InfinispanOrganizationProvider orgProvider, UserModel.UserPreRemovedEvent event, OrganizationModel organization) {
        orgProvider.registerMemberInvalidation(organization, event.getUser());
    }
}

