/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.infinispan;

import java.util.Arrays;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.concurrent.BlockingManager;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.TopologyInfo;

public class DefaultInfinispanConnectionProvider
implements InfinispanConnectionProvider {
    private final EmbeddedCacheManager cacheManager;
    private final TopologyInfo topologyInfo;

    public DefaultInfinispanConnectionProvider(EmbeddedCacheManager cacheManager, TopologyInfo topologyInfo) {
        this.cacheManager = cacheManager;
        this.topologyInfo = topologyInfo;
    }

    private static PersistenceManager persistenceManager(Cache<?, ?> cache) {
        return (PersistenceManager)ComponentRegistry.componentOf(cache, PersistenceManager.class);
    }

    private static CompletionStage<Void> clearPersistenceManager(PersistenceManager persistenceManager) {
        return persistenceManager.clearAllStores((Predicate)PersistenceManager.AccessMode.BOTH);
    }

    @Override
    public <K, V> Cache<K, V> getCache(String name, boolean createIfAbsent) {
        return this.cacheManager.getCache(name, createIfAbsent);
    }

    @Override
    public <K, V> RemoteCache<K, V> getRemoteCache(String cacheName) {
        throw new IllegalStateException("Remote stores cannot be used with Embedded Infinispan.");
    }

    @Override
    public TopologyInfo getTopologyInfo() {
        return this.topologyInfo;
    }

    @Override
    public CompletionStage<Void> migrateToProtoStream() {
        AggregateCompletionStage stage = CompletionStages.aggregateCompletionStage();
        Arrays.stream(CLUSTERED_CACHE_NAMES).map(this::getCache).map(DefaultInfinispanConnectionProvider::persistenceManager).map(DefaultInfinispanConnectionProvider::clearPersistenceManager).forEach(arg_0 -> ((AggregateCompletionStage)stage).dependsOn(arg_0));
        return stage.freeze();
    }

    @Override
    public ScheduledExecutorService getScheduledExecutor() {
        return (ScheduledExecutorService)GlobalComponentRegistry.of((EmbeddedCacheManager)this.cacheManager).getComponent(ScheduledExecutorService.class, "org.infinispan.executors.timeout");
    }

    @Override
    public BlockingManager getBlockingManager() {
        return (BlockingManager)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)this.cacheManager, BlockingManager.class);
    }

    public void close() {
    }
}

