/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.unchecked;

import java.util.Objects;
import java.util.function.Function;

@FunctionalInterface
public interface UncheckedFunction<T, R> {
    public static <T, R> UncheckedFunction<T, R> from(Function<T, R> function) {
        return function::apply;
    }

    public R apply(T var1) throws Exception;

    default public Function<T, R> toFunction() {
        return t -> {
            try {
                return this.apply(t);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    default public <V> UncheckedFunction<V, R> compose(UncheckedFunction<? super V, ? extends T> before) {
        Objects.requireNonNull(before);
        return v -> this.apply(before.apply((Object)v));
    }

    default public <V> UncheckedFunction<T, V> andThen(UncheckedFunction<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        return t -> after.apply((R)this.apply(t));
    }
}

