/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiSkipFirstOp;
import io.smallrye.mutiny.operators.multi.MultiSkipFirstUntilOp;
import io.smallrye.mutiny.operators.multi.MultiSkipLastOp;
import io.smallrye.mutiny.operators.multi.MultiSkipRepetitionsOp;
import io.smallrye.mutiny.operators.multi.MultiSkipUntilOtherOp;
import java.time.Duration;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Predicate;

public class MultiSkip<T> {
    private final Multi<T> upstream;

    public MultiSkip(Multi<T> upstream) {
        this.upstream = upstream;
    }

    @CheckReturnValue
    public Multi<T> first(long n) {
        return Infrastructure.onMultiCreation(new MultiSkipFirstOp<T>(this.upstream, ParameterValidation.positiveOrZero(n, "n")));
    }

    @CheckReturnValue
    public Multi<T> first() {
        return this.first(1L);
    }

    @CheckReturnValue
    public Multi<T> first(Predicate<? super T> predicate) {
        Predicate<? super T> actual = Infrastructure.decorate(ParameterValidation.nonNull(predicate, "predicate"));
        return Infrastructure.onMultiCreation(new MultiSkipFirstUntilOp<T>(this.upstream, actual));
    }

    @CheckReturnValue
    public Multi<T> first(Duration duration) {
        Multi<Long> ticks = Multi.createFrom().ticks().startingAfter(duration).every(duration);
        return Infrastructure.onMultiCreation(new MultiSkipUntilOtherOp<T, Long>(this.upstream, ticks));
    }

    @CheckReturnValue
    public Multi<T> last(int n) {
        return Infrastructure.onMultiCreation(new MultiSkipLastOp<T>(this.upstream, n));
    }

    @CheckReturnValue
    public Multi<T> last() {
        return this.last(1);
    }

    @CheckReturnValue
    public Multi<T> repetitions() {
        return Infrastructure.onMultiCreation(new MultiSkipRepetitionsOp<T>(this.upstream));
    }

    @CheckReturnValue
    public Multi<T> repetitions(Comparator<? super T> comparator) {
        return Infrastructure.onMultiCreation(new MultiSkipRepetitionsOp<T>(this.upstream, comparator));
    }

    @CheckReturnValue
    public Multi<T> where(Predicate<? super T> predicate) {
        Predicate<T> actual = Infrastructure.decorate(ParameterValidation.nonNull(predicate, "predicate"));
        return this.upstream.select().where(actual.negate());
    }

    @CheckReturnValue
    public Multi<T> when(Function<? super T, Uni<Boolean>> predicate) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(predicate, "predicate"));
        return this.upstream.onItem().transformToMultiAndConcatenate(res -> {
            Uni uni = (Uni)actual.apply(res);
            return uni.map(pass -> pass != false ? null : res).toMulti();
        });
    }
}

