/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.webjar;

import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathTree;
import io.quarkus.paths.PathVisit;
import io.quarkus.runtime.ApplicationConfig;
import io.quarkus.vertx.http.deployment.webjar.CombinedWebJarResourcesFilter;
import io.quarkus.vertx.http.deployment.webjar.InMemoryTargetVisitor;
import io.quarkus.vertx.http.deployment.webjar.InsertVariablesResourcesFilter;
import io.quarkus.vertx.http.deployment.webjar.PathTargetVisitor;
import io.quarkus.vertx.http.deployment.webjar.WebJarBuildItem;
import io.quarkus.vertx.http.deployment.webjar.WebJarResourcesFilter;
import io.quarkus.vertx.http.deployment.webjar.WebJarResourcesTargetVisitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class WebJarUtil {
    private static final Logger LOG = Logger.getLogger(WebJarUtil.class);
    private static final String CUSTOM_MEDIA_FOLDER = "META-INF/branding/";
    private static final List<String> OVERRIDABLE_RESOURCES = Arrays.asList("logo.png", "favicon.ico", "style.css");

    private WebJarUtil() {
    }

    static Path copyResourcesForDevOrTest(CurateOutcomeBuildItem curateOutcomeBuildItem, ApplicationConfig config, WebJarBuildItem webJar, ResolvedDependency resourcesArtifact, Path deploymentBasePath) throws IOException {
        Path deploymentPath = Files.createDirectories(deploymentBasePath, new FileAttribute[0]);
        PathTargetVisitor visitor = new PathTargetVisitor(deploymentPath);
        WebJarUtil.copyResources(curateOutcomeBuildItem, config, webJar, resourcesArtifact, visitor);
        return deploymentPath;
    }

    static Map<String, byte[]> copyResourcesForProduction(CurateOutcomeBuildItem curateOutcomeBuildItem, ApplicationConfig config, WebJarBuildItem webJar, ResolvedDependency resourcesArtifact) {
        InMemoryTargetVisitor visitor = new InMemoryTargetVisitor();
        WebJarUtil.copyResources(curateOutcomeBuildItem, config, webJar, resourcesArtifact, visitor);
        return visitor.getContent();
    }

    private static void copyResources(CurateOutcomeBuildItem curateOutcomeBuildItem, final ApplicationConfig config, final WebJarBuildItem webJar, final ResolvedDependency resourcesArtifact, final WebJarResourcesTargetVisitor visitor) {
        final ResolvedDependency userApplication = curateOutcomeBuildItem.getApplicationModel().getAppArtifact();
        final ClassLoader classLoader = WebJarUtil.class.getClassLoader();
        resourcesArtifact.getContentTree().accept(webJar.getRoot(), (Consumer)new Consumer<PathVisit>(){

            @Override
            public void accept(PathVisit pathVisit) {
                if (pathVisit == null || !Files.isDirectory(pathVisit.getPath(), new LinkOption[0])) {
                    return;
                }
                ArrayList<WebJarResourcesFilter> filters = new ArrayList<WebJarResourcesFilter>();
                if (webJar.getFilter() != null) {
                    filters.add(webJar.getFilter());
                }
                filters.add(new InsertVariablesResourcesFilter(config, userApplication));
                try {
                    Files.walkFileTree(pathVisit.getPath(), new ResourcesFileVisitor(visitor, pathVisit.getPath(), resourcesArtifact, userApplication, new CombinedWebJarResourcesFilter(filters), classLoader, webJar));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
    }

    static ResolvedDependency getAppArtifact(CurateOutcomeBuildItem curateOutcomeBuildItem, GACT artifactKey) {
        for (ResolvedDependency dep : curateOutcomeBuildItem.getApplicationModel().getDependencies()) {
            if (!dep.getKey().equals((Object)artifactKey)) continue;
            return dep;
        }
        throw new RuntimeException("Could not find artifact " + String.valueOf(artifactKey) + " among the application dependencies");
    }

    private static String getModuleOverrideName(ResolvedDependency artifact, String filename) {
        String type = filename.substring(filename.lastIndexOf("."));
        return artifact.getArtifactId() + type;
    }

    private static InputStream getOverride(ResolvedDependency userApplication, ClassLoader classLoader, String filename, String moduleName, boolean useDefaultQuarkusBranding) {
        InputStream overrideStream = WebJarUtil.getCustomOverride(userApplication, filename, moduleName);
        if (overrideStream == null && useDefaultQuarkusBranding) {
            overrideStream = WebJarUtil.getQuarkusOverride(classLoader, filename, moduleName);
        }
        return overrideStream;
    }

    private static InputStream getCustomOverride(ResolvedDependency userApplication, String filename, String moduleName) {
        byte[] content = WebJarUtil.readFromPathTree(userApplication.getContentTree(), CUSTOM_MEDIA_FOLDER + moduleName);
        if (content != null) {
            return new ByteArrayInputStream(content);
        }
        content = WebJarUtil.readFromPathTree(userApplication.getContentTree(), CUSTOM_MEDIA_FOLDER + filename);
        if (content != null) {
            return new ByteArrayInputStream(content);
        }
        return null;
    }

    private static byte[] readFromPathTree(PathTree tree, String relativePath) {
        return (byte[])tree.apply(relativePath, visit -> {
            if (visit == null) {
                return null;
            }
            try {
                return Files.readAllBytes(visit.getPath());
            }
            catch (IOException e) {
                LOG.error((Object)("Could not read file content " + String.valueOf(visit.getPath())), (Throwable)e);
                return null;
            }
        });
    }

    private static InputStream getQuarkusOverride(ClassLoader classLoader, String filename, String moduleName) {
        InputStream stream = classLoader.getResourceAsStream(CUSTOM_MEDIA_FOLDER + moduleName);
        if (stream != null) {
            return stream;
        }
        return classLoader.getResourceAsStream(CUSTOM_MEDIA_FOLDER + filename);
    }

    private static class ResourcesFileVisitor
    extends SimpleFileVisitor<Path> {
        private final WebJarResourcesTargetVisitor visitor;
        private final Path rootFolderToCopy;
        private final ResolvedDependency resourcesArtifact;
        private final ResolvedDependency userApplication;
        private final WebJarResourcesFilter filter;
        private final ClassLoader classLoader;
        private final WebJarBuildItem webJar;

        public ResourcesFileVisitor(WebJarResourcesTargetVisitor visitor, Path rootFolderToCopy, ResolvedDependency resourcesArtifact, ResolvedDependency userApplication, WebJarResourcesFilter filter, ClassLoader classLoader, WebJarBuildItem webJar) {
            this.visitor = visitor;
            this.rootFolderToCopy = rootFolderToCopy;
            this.resourcesArtifact = resourcesArtifact;
            this.userApplication = userApplication;
            this.filter = filter;
            this.classLoader = classLoader;
            this.webJar = webJar;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            this.visitor.visitDirectory(this.rootFolderToCopy.relativize(dir).toString());
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            WebJarResourcesFilter.FilterResult filterResult;
            String fileName = this.rootFolderToCopy.relativize(file).toString();
            String moduleName = WebJarUtil.getModuleOverrideName(this.resourcesArtifact, fileName);
            boolean overrideFileCreated = false;
            if (OVERRIDABLE_RESOURCES.contains(fileName)) {
                filterResult = this.filter.apply(fileName, WebJarUtil.getOverride(this.userApplication, this.classLoader, fileName, moduleName, this.webJar.getUseDefaultQuarkusBranding()));
                try {
                    if (filterResult.hasStream()) {
                        overrideFileCreated = true;
                        this.visitor.visitFile(fileName, filterResult.getStream());
                    }
                }
                finally {
                    if (filterResult != null) {
                        filterResult.close();
                    }
                }
            }
            if (!overrideFileCreated) {
                filterResult = this.filter.apply(fileName, Files.newInputStream(file, new OpenOption[0]));
                try {
                    if ((!this.visitor.supportsOnlyCopyingNonArtifactFiles() || !this.webJar.getOnlyCopyNonArtifactFiles() || filterResult.isChanged()) && filterResult.hasStream()) {
                        this.visitor.visitFile(fileName, filterResult.getStream());
                    }
                }
                finally {
                    if (filterResult != null) {
                        filterResult.close();
                    }
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

