/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.jsonrpc;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import io.quarkus.vertx.runtime.jackson.JsonUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ByteArrayInputStreamDeserializer
extends JsonDeserializer<ByteArrayInputStream> {
    public ByteArrayInputStream deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String text = p.getText();
        try {
            byte[] decode = JsonUtil.BASE64_DECODER.decode(text);
            return new ByteArrayInputStream(decode);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(p, "Expected a base64 encoded byte array", (Object)text, ByteArrayInputStream.class);
        }
    }
}

