/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.conn;

import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import liquibase.ContextExpression;
import liquibase.Labels;
import liquibase.change.CheckSum;
import liquibase.change.ColumnConfig;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.StandardChangeLogHistoryService;
import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.exception.DatabaseException;
import liquibase.executor.jvm.ChangelogJdbcMdcListener;
import liquibase.logging.LogFactory;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddPrimaryKeyStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import org.keycloak.common.util.reflections.Reflections;

public class CustomChangeLogHistoryService
extends StandardChangeLogHistoryService {
    private List<RanChangeSet> ranChangeSetList;
    private boolean serviceInitialized;

    public boolean supports(Database database) {
        return database instanceof MySQLDatabase;
    }

    public void init() throws DatabaseException {
        super.init();
        if (this.serviceInitialized) {
            return;
        }
        this.serviceInitialized = true;
        if (!this.existsDatabaseChangelogPK()) {
            this.createDatabaseChangelogPK();
        }
    }

    public List<RanChangeSet> getRanChangeSets() throws DatabaseException {
        if (this.ranChangeSetList == null) {
            String databaseChangeLogTableName = this.getDatabase().escapeTableName(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName());
            ArrayList<RanChangeSet> ranChangeSetList = new ArrayList<RanChangeSet>();
            if (this.hasDatabaseChangeLogTable()) {
                LogFactory.getLogger().info("Reading from " + databaseChangeLogTableName);
                List results = this.queryDatabaseChangeLogTable(this.getDatabase());
                for (Map rs : results) {
                    String fileName = rs.get("FILENAME").toString();
                    String author = rs.get("AUTHOR").toString();
                    String id = rs.get("ID").toString();
                    String md5sum = rs.get("MD5SUM") == null || this.getDatabaseChecksumsCompatible() ? null : rs.get("MD5SUM").toString();
                    String description = rs.get("DESCRIPTION") == null ? null : rs.get("DESCRIPTION").toString();
                    String comments = rs.get("COMMENTS") == null ? null : rs.get("COMMENTS").toString();
                    Object tmpDateExecuted = rs.get("DATEEXECUTED");
                    Date dateExecuted = null;
                    if (tmpDateExecuted instanceof Date) {
                        dateExecuted = (Date)tmpDateExecuted;
                    } else if (tmpDateExecuted instanceof LocalDateTime) {
                        dateExecuted = Date.from(((LocalDateTime)tmpDateExecuted).atZone(ZoneId.systemDefault()).toInstant());
                    } else {
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        try {
                            dateExecuted = df.parse((String)tmpDateExecuted);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    String tmpOrderExecuted = rs.get("ORDEREXECUTED").toString();
                    Integer orderExecuted = tmpOrderExecuted == null ? null : Integer.valueOf(tmpOrderExecuted);
                    String tag = rs.get("TAG") == null ? null : rs.get("TAG").toString();
                    String execType = rs.get("EXECTYPE") == null ? null : rs.get("EXECTYPE").toString();
                    ContextExpression contexts = new ContextExpression((String)rs.get("CONTEXTS"));
                    Labels labels = new Labels((String)rs.get("LABELS"));
                    String deploymentId = (String)rs.get("DEPLOYMENT_ID");
                    try {
                        RanChangeSet ranChangeSet = new RanChangeSet(fileName, id, author, CheckSum.parse((String)md5sum), dateExecuted, tag, ChangeSet.ExecType.valueOf((String)execType), description, comments, contexts, labels, deploymentId);
                        ranChangeSet.setOrderExecuted(orderExecuted);
                        ranChangeSetList.add(ranChangeSet);
                    }
                    catch (IllegalArgumentException e) {
                        LogFactory.getLogger().severe("Unknown EXECTYPE from database: " + execType);
                        throw e;
                    }
                }
            }
            this.ranChangeSetList = ranChangeSetList;
        }
        return Collections.unmodifiableList(this.ranChangeSetList);
    }

    private boolean getDatabaseChecksumsCompatible() {
        Field f = Reflections.findDeclaredField(StandardChangeLogHistoryService.class, (String)"databaseChecksumsCompatible");
        if (f != null) {
            f.setAccessible(true);
            Boolean databaseChecksumsCompatible = (Boolean)Reflections.getFieldValue((Field)f, (Object)((Object)this), Boolean.class);
            return databaseChecksumsCompatible == null ? true : databaseChecksumsCompatible;
        }
        return true;
    }

    public int getPriority() {
        return super.getPriority() + 1;
    }

    private boolean existsDatabaseChangelogPK() throws DatabaseException {
        try {
            PrimaryKey example = new PrimaryKey();
            Table table = new Table();
            table.setSchema(new Schema(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName()));
            table.setName(this.getDatabaseChangeLogTableName());
            example.setTable(table);
            return SnapshotGeneratorFactory.getInstance().has((DatabaseObject)example, this.getDatabase());
        }
        catch (InvalidExampleException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    private void createDatabaseChangelogPK() throws DatabaseException {
        block2: {
            AddPrimaryKeyStatement pkStatement = new AddPrimaryKeyStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), ColumnConfig.arrayFromNames((String)"ID, AUTHOR, FILENAME"), "PK_DATABASECHANGELOG");
            try {
                ChangelogJdbcMdcListener.execute((Database)this.getDatabase(), ex -> ex.execute((SqlStatement)pkStatement));
                this.getDatabase().commit();
            }
            catch (DatabaseException e) {
                if (this.existsDatabaseChangelogPK()) break block2;
                throw e;
            }
        }
    }
}

