/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.metrics;

import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.metrics.HistogramDataPointStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.MetricsMarshalerUtil;
import io.opentelemetry.proto.metrics.v1.internal.Histogram;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import java.io.IOException;
import java.util.Collection;

final class HistogramStatelessMarshaler
implements StatelessMarshaler<HistogramData> {
    static final HistogramStatelessMarshaler INSTANCE = new HistogramStatelessMarshaler();
    private static final MarshalerContext.Key DATA_POINT_SIZE_CALCULATOR_KEY = MarshalerContext.key();
    private static final MarshalerContext.Key DATA_POINT_WRITER_KEY = MarshalerContext.key();

    private HistogramStatelessMarshaler() {
    }

    public void writeTo(Serializer output, HistogramData histogram, MarshalerContext context) throws IOException {
        output.serializeRepeatedMessageWithContext(Histogram.DATA_POINTS, histogram.getPoints(), (StatelessMarshaler)HistogramDataPointStatelessMarshaler.INSTANCE, context, DATA_POINT_WRITER_KEY);
        output.serializeEnum(Histogram.AGGREGATION_TEMPORALITY, MetricsMarshalerUtil.mapToTemporality(histogram.getAggregationTemporality()));
    }

    public int getBinarySerializedSize(HistogramData histogram, MarshalerContext context) {
        int size = 0;
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext((ProtoFieldInfo)Histogram.DATA_POINTS, (Collection)histogram.getPoints(), (StatelessMarshaler)HistogramDataPointStatelessMarshaler.INSTANCE, (MarshalerContext)context, (MarshalerContext.Key)DATA_POINT_SIZE_CALCULATOR_KEY);
        return size += MarshalerUtil.sizeEnum((ProtoFieldInfo)Histogram.AGGREGATION_TEMPORALITY, (ProtoEnumInfo)MetricsMarshalerUtil.mapToTemporality(histogram.getAggregationTemporality()));
    }
}

