/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.EntityFilterException;
import org.hibernate.FetchNotFoundException;
import org.hibernate.Hibernate;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntityInitializerImpl;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractBatchEntitySelectFetchInitializer<Data extends AbstractBatchEntitySelectFetchInitializerData>
extends EntitySelectFetchInitializer<Data>
implements EntityInitializer<Data> {
    protected final EntityInitializer<InitializerData> owningEntityInitializer;

    public AbstractBatchEntitySelectFetchInitializer(InitializerParent<?> parent, ToOneAttributeMapping toOneMapping, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResult<?> keyResult, boolean affectedByFilter, AssemblerCreationState creationState) {
        super(parent, toOneMapping, fetchedNavigable, concreteDescriptor, keyResult, affectedByFilter, creationState);
        this.owningEntityInitializer = Initializer.findOwningEntityInitializer(parent);
        assert (this.owningEntityInitializer != null) : "This initializer requires an owning parent entity initializer";
    }

    protected abstract void registerResolutionListener(Data var1);

    @Override
    public void resolveKey(Data data) {
        if (((InitializerData)data).getState() != Initializer.State.UNINITIALIZED) {
            return;
        }
        ((AbstractBatchEntitySelectFetchInitializerData)data).entityKey = null;
        ((InitializerData)data).setInstance(null);
        RowProcessingState rowProcessingState = ((InitializerData)data).getRowProcessingState();
        Initializer<?> initializer = this.keyAssembler.getInitializer();
        if (initializer != null) {
            Object subData = initializer.getData(rowProcessingState);
            initializer.resolveKey(subData);
            ((AbstractBatchEntitySelectFetchInitializerData)data).entityIdentifier = null;
            ((InitializerData)data).setState(((InitializerData)subData).getState() == Initializer.State.MISSING ? Initializer.State.MISSING : Initializer.State.KEY_RESOLVED);
        } else {
            ((AbstractBatchEntitySelectFetchInitializerData)data).entityIdentifier = this.keyAssembler.assemble(rowProcessingState);
            ((InitializerData)data).setState(((AbstractBatchEntitySelectFetchInitializerData)data).entityIdentifier == null ? Initializer.State.MISSING : Initializer.State.KEY_RESOLVED);
        }
    }

    @Override
    public void resolveInstance(Data data) {
        if (((InitializerData)data).getState() != Initializer.State.KEY_RESOLVED) {
            return;
        }
        ((InitializerData)data).setState(Initializer.State.RESOLVED);
        RowProcessingState rowProcessingState = ((InitializerData)data).getRowProcessingState();
        if (((AbstractBatchEntitySelectFetchInitializerData)data).entityIdentifier == null) {
            ((AbstractBatchEntitySelectFetchInitializerData)data).entityIdentifier = this.keyAssembler.assemble(rowProcessingState);
            if (((AbstractBatchEntitySelectFetchInitializerData)data).entityIdentifier == null) {
                ((AbstractBatchEntitySelectFetchInitializerData)data).entityKey = null;
                ((InitializerData)data).setInstance(null);
                ((InitializerData)data).setState(Initializer.State.MISSING);
                return;
            }
        }
        this.resolveInstanceFromIdentifier(data);
    }

    protected void resolveInstanceFromIdentifier(Data data) {
        if (((AbstractBatchEntitySelectFetchInitializerData)data).batchDisabled) {
            this.initialize((EntitySelectFetchInitializer.EntitySelectFetchInitializerData)data);
        } else {
            ((AbstractBatchEntitySelectFetchInitializerData)data).entityKey = new EntityKey(((AbstractBatchEntitySelectFetchInitializerData)data).entityIdentifier, this.concreteDescriptor);
            ((InitializerData)data).setInstance(this.getExistingInitializedInstance(data));
            if (((InitializerData)data).getInstance() == null) {
                this.registerToBatchFetchQueue(data);
            }
        }
    }

    @Override
    public void resolveInstance(Object instance, Data data) {
        if (instance == null) {
            ((InitializerData)data).setState(Initializer.State.MISSING);
            ((AbstractBatchEntitySelectFetchInitializerData)data).entityKey = null;
            ((InitializerData)data).setInstance(null);
            return;
        }
        RowProcessingState rowProcessingState = ((InitializerData)data).getRowProcessingState();
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(instance);
        ((AbstractBatchEntitySelectFetchInitializerData)data).entityKey = null;
        ((AbstractBatchEntitySelectFetchInitializerData)data).entityIdentifier = null;
        if (lazyInitializer == null) {
            PersistentAttributeInterceptor interceptor;
            ((InitializerData)data).setInstance(instance);
            if (this.concreteDescriptor.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading() && ManagedTypeHelper.isPersistentAttributeInterceptable(instance) && (interceptor = EntityInitializerImpl.getAttributeInterceptor(instance)) instanceof EnhancementAsProxyLazinessInterceptor) {
                EnhancementAsProxyLazinessInterceptor enhancementInterceptor = (EnhancementAsProxyLazinessInterceptor)interceptor;
                if (enhancementInterceptor.isInitialized()) {
                    ((InitializerData)data).setState(Initializer.State.INITIALIZED);
                } else {
                    ((InitializerData)data).setState(Initializer.State.RESOLVED);
                    ((AbstractBatchEntitySelectFetchInitializerData)data).entityIdentifier = enhancementInterceptor.getIdentifier();
                }
            } else {
                ((InitializerData)data).setState(Initializer.State.RESOLVED);
                ((AbstractBatchEntitySelectFetchInitializerData)data).entityIdentifier = this.concreteDescriptor.getIdentifier(instance, rowProcessingState.getSession());
            }
            if (this.keyIsEager && ((AbstractBatchEntitySelectFetchInitializerData)data).entityIdentifier == null) {
                ((AbstractBatchEntitySelectFetchInitializerData)data).entityIdentifier = this.concreteDescriptor.getIdentifier(instance, rowProcessingState.getSession());
            }
        } else if (lazyInitializer.isUninitialized()) {
            ((InitializerData)data).setState(Initializer.State.RESOLVED);
            ((AbstractBatchEntitySelectFetchInitializerData)data).entityIdentifier = lazyInitializer.getInternalIdentifier();
        } else {
            ((InitializerData)data).setState(Initializer.State.INITIALIZED);
            if (this.keyIsEager) {
                ((AbstractBatchEntitySelectFetchInitializerData)data).entityIdentifier = lazyInitializer.getInternalIdentifier();
            }
            ((InitializerData)data).setInstance(lazyInitializer.getImplementation());
        }
        if (((InitializerData)data).getState() == Initializer.State.RESOLVED) {
            this.resolveInstanceFromIdentifier(data);
        }
        if (this.keyIsEager) {
            Initializer<?> initializer = this.keyAssembler.getInitializer();
            assert (initializer != null);
            initializer.resolveInstance(((AbstractBatchEntitySelectFetchInitializerData)data).entityIdentifier, rowProcessingState);
        } else if (rowProcessingState.needsResolveState()) {
            this.keyAssembler.resolveState(rowProcessingState);
        }
    }

    @Override
    public void initializeInstance(Data data) {
        if (((InitializerData)data).getState() != Initializer.State.RESOLVED) {
            return;
        }
        ((InitializerData)data).setState(Initializer.State.INITIALIZED);
        if (((AbstractBatchEntitySelectFetchInitializerData)data).batchDisabled) {
            Hibernate.initialize(((InitializerData)data).getInstance());
        }
    }

    protected Object getExistingInitializedInstance(Data data) {
        SharedSessionContractImplementor session = ((InitializerData)data).getRowProcessingState().getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        EntityHolder holder = persistenceContext.getEntityHolder(((AbstractBatchEntitySelectFetchInitializerData)data).entityKey);
        if (holder != null && holder.getEntity() != null && holder.isEventuallyInitialized()) {
            return holder.getEntity();
        }
        this.registerResolutionListener(data);
        return null;
    }

    protected void registerToBatchFetchQueue(Data data) {
        assert (((AbstractBatchEntitySelectFetchInitializerData)data).entityKey != null);
        ((InitializerData)data).getRowProcessingState().getSession().getPersistenceContextInternal().getBatchFetchQueue().addBatchLoadableEntityKey(((AbstractBatchEntitySelectFetchInitializerData)data).entityKey);
    }

    @Override
    public void initializeInstanceFromParent(Object parentInstance, Data data) {
        AttributeMapping attributeMapping = this.getInitializedPart().asAttributeMapping();
        Object instance = attributeMapping != null ? attributeMapping.getValue(parentInstance) : parentInstance;
        ((AbstractBatchEntitySelectFetchInitializerData)data).entityKey = null;
        ((InitializerData)data).setInstance(null);
        if (instance == null) {
            ((InitializerData)data).setState(Initializer.State.MISSING);
        } else {
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(instance);
            if (lazyInitializer != null && lazyInitializer.isUninitialized()) {
                ((AbstractBatchEntitySelectFetchInitializerData)data).entityKey = new EntityKey(lazyInitializer.getInternalIdentifier(), this.concreteDescriptor);
                this.registerToBatchFetchQueue(data);
            }
            ((InitializerData)data).setState(Initializer.State.INITIALIZED);
        }
    }

    protected static Object loadInstance(EntityKey entityKey, ToOneAttributeMapping toOneMapping, boolean affectedByFilter, SharedSessionContractImplementor session) {
        Object instance = session.internalLoad(entityKey.getEntityName(), entityKey.getIdentifier(), true, toOneMapping.isInternalLoadNullable());
        if (instance == null && toOneMapping.getNotFoundAction() != NotFoundAction.IGNORE) {
            if (affectedByFilter) {
                throw new EntityFilterException(entityKey.getEntityName(), entityKey.getIdentifier(), toOneMapping.getNavigableRole().getFullPath());
            }
            if (toOneMapping.getNotFoundAction() == NotFoundAction.EXCEPTION) {
                throw new FetchNotFoundException(entityKey.getEntityName(), entityKey.getIdentifier());
            }
        }
        return instance;
    }

    protected AttributeMapping[] getParentEntityAttributes(String attributeName) {
        EntityPersister entityDescriptor = this.owningEntityInitializer.getEntityDescriptor();
        AttributeMapping[] parentEntityAttributes = new AttributeMapping[entityDescriptor.getRootEntityDescriptor().getSubclassEntityNames().size()];
        parentEntityAttributes[entityDescriptor.getSubclassId()] = AbstractBatchEntitySelectFetchInitializer.getParentEntityAttribute(entityDescriptor, this.toOneMapping, attributeName);
        for (EntityMappingType subMappingType : entityDescriptor.getSubMappingTypes()) {
            parentEntityAttributes[subMappingType.getSubclassId()] = AbstractBatchEntitySelectFetchInitializer.getParentEntityAttribute(subMappingType, this.toOneMapping, attributeName);
        }
        return parentEntityAttributes;
    }

    protected static AttributeMapping getParentEntityAttribute(EntityMappingType subMappingType, ToOneAttributeMapping referencedModelPart, String attributeName) {
        AttributeMapping parentAttribute = subMappingType.findAttributeMapping(attributeName);
        if (parentAttribute != null && parentAttribute.getDeclaringType() == referencedModelPart.getDeclaringType().findContainingEntityMapping()) {
            return parentAttribute;
        }
        return null;
    }

    public static abstract class AbstractBatchEntitySelectFetchInitializerData
    extends EntitySelectFetchInitializer.EntitySelectFetchInitializerData {
        final boolean batchDisabled;
        protected @Nullable EntityKey entityKey;

        public AbstractBatchEntitySelectFetchInitializerData(AbstractBatchEntitySelectFetchInitializer<?> initializer, RowProcessingState rowProcessingState) {
            super(initializer, rowProcessingState);
            this.batchDisabled = rowProcessingState.isScrollResult() || !rowProcessingState.getLoadQueryInfluencers().effectivelyBatchLoadable(initializer.toOneMapping.getEntityMappingType().getEntityPersister());
        }
    }
}

