/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.cte;

import org.hibernate.query.NullPrecedence;
import org.hibernate.query.SortDirection;
import org.hibernate.query.criteria.JpaCteCriteriaAttribute;
import org.hibernate.query.criteria.JpaSearchOrder;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.cte.SqmCteTableColumn;

public class SqmSearchClauseSpecification
implements JpaSearchOrder {
    private final SqmCteTableColumn cteColumn;
    private final SortDirection sortOrder;
    private NullPrecedence nullPrecedence;

    public SqmSearchClauseSpecification(SqmCteTableColumn cteColumn, SortDirection sortOrder, NullPrecedence nullPrecedence) {
        if (cteColumn == null) {
            throw new IllegalArgumentException("Null cte column");
        }
        this.cteColumn = cteColumn;
        this.sortOrder = sortOrder;
        this.nullPrecedence = nullPrecedence;
    }

    public SqmSearchClauseSpecification copy(SqmCopyContext context) {
        return new SqmSearchClauseSpecification(this.cteColumn, this.sortOrder, this.nullPrecedence);
    }

    public SqmCteTableColumn getCteColumn() {
        return this.cteColumn;
    }

    @Override
    public JpaSearchOrder nullPrecedence(NullPrecedence precedence) {
        this.nullPrecedence = precedence;
        return this;
    }

    @Override
    public boolean isAscending() {
        return this.sortOrder == SortDirection.ASCENDING;
    }

    @Override
    public JpaSearchOrder reverse() {
        SortDirection newSortOrder = this.sortOrder == null ? SortDirection.DESCENDING : this.sortOrder.reverse();
        return new SqmSearchClauseSpecification(this.cteColumn, newSortOrder, this.nullPrecedence);
    }

    @Override
    public JpaCteCriteriaAttribute getAttribute() {
        return this.cteColumn;
    }

    @Override
    public SortDirection getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public NullPrecedence getNullPrecedence() {
        return this.nullPrecedence;
    }
}

