/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree;

import jakarta.persistence.criteria.JoinType;
import org.hibernate.sql.ast.SqlAstJoinType;

public enum SqmJoinType {
    INNER("inner", SqlAstJoinType.INNER, JoinType.INNER),
    LEFT("left outer", SqlAstJoinType.LEFT, JoinType.LEFT),
    RIGHT("right outer", SqlAstJoinType.RIGHT, JoinType.RIGHT),
    CROSS("cross", SqlAstJoinType.CROSS, null),
    FULL("full", SqlAstJoinType.FULL, null);

    private final String text;
    private final SqlAstJoinType correspondingSqlAstJoinType;
    private final JoinType correspondingJpaJoinType;

    private SqmJoinType(String text, SqlAstJoinType correspondingSqlAstJoinType, JoinType correspondingJpaJoinType) {
        this.text = text;
        this.correspondingSqlAstJoinType = correspondingSqlAstJoinType;
        this.correspondingJpaJoinType = correspondingJpaJoinType;
    }

    public String toString() {
        return this.text;
    }

    public String getText() {
        return this.text;
    }

    public SqlAstJoinType getCorrespondingSqlJoinType() {
        return this.correspondingSqlAstJoinType;
    }

    public JoinType getCorrespondingJpaJoinType() {
        return this.correspondingJpaJoinType;
    }

    public static SqmJoinType from(JoinType jpaJoinType) {
        switch (jpaJoinType) {
            case INNER: {
                return INNER;
            }
            case LEFT: {
                return LEFT;
            }
            case RIGHT: {
                return RIGHT;
            }
        }
        return INNER;
    }
}

