/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import java.util.Locale;

public enum SortDirection {
    ASCENDING,
    DESCENDING;


    public SortDirection reverse() {
        switch (this) {
            case ASCENDING: {
                return DESCENDING;
            }
            case DESCENDING: {
                return ASCENDING;
            }
        }
        return this;
    }

    public static SortDirection interpret(String value) {
        if (value == null) {
            return null;
        }
        switch (value.toLowerCase(Locale.ROOT)) {
            case "asc": 
            case "ascending": {
                return ASCENDING;
            }
            case "desc": 
            case "descending": {
                return DESCENDING;
            }
        }
        throw new IllegalArgumentException("Unknown sort order: " + value);
    }
}

