/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerationStrategy;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.factory.spi.StandardGenerator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

@Deprecated(since="6.0")
public class GUIDGenerator
implements IdentifierGenerator,
StandardGenerator {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(GUIDGenerator.class);
    private static boolean WARNED;

    public GUIDGenerator() {
        if (!WARNED) {
            WARNED = true;
            LOG.deprecatedUuidGenerator(UUIDGenerator.class.getName(), UUIDGenerationStrategy.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object generate(SharedSessionContractImplementor session, Object obj) throws HibernateException {
        String sql = session.getJdbcServices().getJdbcEnvironment().getDialect().getSelectGUIDString();
        try {
            PreparedStatement st = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(sql);
            try {
                ResultSet rs = session.getJdbcCoordinator().getResultSetReturn().extract(st, sql);
                try {
                    if (!rs.next()) {
                        throw new HibernateException("The database returned no GUID identity value");
                    }
                    String result = rs.getString(1);
                    LOG.guidGenerated(result);
                    String string = result;
                    session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(rs, st);
                    return string;
                }
                catch (Throwable throwable) {
                    session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(rs, st);
                    throw throwable;
                }
            }
            finally {
                session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(st);
                session.getJdbcCoordinator().afterStatementExecution();
            }
        }
        catch (SQLException sqle) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(sqle, "could not retrieve GUID", sql);
        }
    }
}

