/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderEvent;

public class FederatedIdentityModel {
    private String token;
    private final String userId;
    private final String identityProvider;
    private final String userName;

    public FederatedIdentityModel(String providerAlias, String userId, String userName) {
        this(providerAlias, userId, userName, null);
    }

    public FederatedIdentityModel(String providerAlias, String userId, String userName, String token) {
        this.identityProvider = providerAlias;
        this.userId = userId;
        this.userName = userName;
        this.token = token;
    }

    public FederatedIdentityModel(FederatedIdentityModel originalIdentity, String userId) {
        this.identityProvider = originalIdentity.getIdentityProvider();
        this.userId = userId;
        this.userName = originalIdentity.getUserName();
        this.token = originalIdentity.getToken();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getIdentityProvider() {
        return this.identityProvider;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FederatedIdentityModel that = (FederatedIdentityModel)o;
        if (this.userId != null ? !this.userId.equals(that.userId) : that.userId != null) {
            return false;
        }
        if (!this.identityProvider.equals(that.identityProvider)) {
            return false;
        }
        return this.userName != null ? this.userName.equals(that.userName) : that.userName == null;
    }

    public int hashCode() {
        int result = this.userId != null ? this.userId.hashCode() : 0;
        result = 31 * result + this.identityProvider.hashCode();
        result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
        return result;
    }

    public static interface FederatedIdentityRemovedEvent
    extends ProviderEvent {
        public KeycloakSession getKeycloakSession();

        public RealmModel getRealm();

        public UserModel getUser();

        public FederatedIdentityModel getFederatedIdentity();
    }

    public static interface FederatedIdentityCreatedEvent
    extends ProviderEvent {
        public KeycloakSession getKeycloakSession();

        public RealmModel getRealm();

        public UserModel getUser();

        public FederatedIdentityModel getFederatedIdentity();
    }
}

