/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.util.concurrent.TimeUnit;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.stats.impl.AbstractStats;
import org.infinispan.util.logging.Log;

public abstract class AbstractClusterStats
extends AbstractStats {
    AbstractClusterStats(Log log) {
        super(log);
    }

    @Override
    abstract void updateStats() throws Exception;

    @ManagedAttribute(description="Gets the threshold for cluster wide stats refresh (milliseconds)", displayName="Stale Stats Threshold", dataType=DataType.TRAIT, writable=true, clusterWide=true)
    public long getStaleStatsThreshold() {
        return this.staleStatsThreshold;
    }

    @ManagedAttribute(description="Number of seconds since the cluster-wide statistics were last reset", displayName="Seconds since cluster-wide statistics were reset", units=Units.SECONDS, clusterWide=true)
    public long getTimeSinceReset() {
        long result = -1L;
        if (this.isStatisticsEnabled()) {
            result = this.timeService.timeDuration(this.resetNanoseconds.get(), TimeUnit.SECONDS);
        }
        return result;
    }

    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", displayName="Statistics enabled", dataType=DataType.TRAIT, writable=true, clusterWide=true)
    public boolean isStatisticsEnabled() {
        return this.getStatisticsEnabled();
    }
}

