/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalJmxConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.ObjectNameKeys;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NONE)
abstract class AbstractJmxRegistration
implements ObjectNameKeys {
    private static final Log log = LogFactory.getLog(AbstractJmxRegistration.class);
    @Inject
    GlobalConfiguration globalConfig;
    @Inject
    BasicComponentRegistry basicComponentRegistry;
    volatile MBeanServer mBeanServer;
    String groupName;
    private List<ResourceDMBean> resourceDMBeans;
    private final String mainComponent;

    AbstractJmxRegistration(String mainComponent) {
        this.mainComponent = mainComponent;
    }

    public void start() {
        if (this.mBeanServer == null) {
            MBeanServer mBeanServer = null;
            try {
                GlobalJmxConfiguration jmx = this.globalConfig.jmx();
                MBeanServerLookup lookup = jmx.mbeanServerLookup();
                if (jmx.enabled() && lookup != null) {
                    mBeanServer = lookup.getMBeanServer((Properties)jmx.properties());
                }
            }
            catch (Exception e) {
                Log.CONTAINER.warn("Ignoring exception in MBean server lookup", e);
            }
            if (mBeanServer != null) {
                this.groupName = this.initGroup();
                this.resourceDMBeans = Collections.synchronizedList(this.getResourceDMBeansFromComponents());
                this.mBeanServer = mBeanServer;
                try {
                    for (ResourceDMBean resourceDMBean : this.resourceDMBeans) {
                        ObjectName objectName = this.getObjectName(this.groupName, resourceDMBean.getMBeanName());
                        this.register(resourceDMBean, objectName, mBeanServer);
                    }
                }
                catch (IllegalArgumentException | InstanceAlreadyExistsException e) {
                    throw Log.CONTAINER.jmxMBeanAlreadyRegistered(this.globalConfig.jmx().domain(), e);
                }
                catch (Exception e) {
                    throw new CacheException("Failure while registering MBeans", (Throwable)e);
                }
            }
        } else {
            this.resourceDMBeans = Collections.synchronizedList(this.getResourceDMBeansFromComponents());
            try {
                for (ResourceDMBean resourceDMBean : this.resourceDMBeans) {
                    ObjectName objectName = this.getObjectName(this.groupName, resourceDMBean.getMBeanName());
                    this.register(resourceDMBean, objectName, this.mBeanServer);
                }
            }
            catch (Exception e) {
                throw new CacheException("Failure while registering MBeans", (Throwable)e);
            }
        }
    }

    public void stop() {
        if (this.mBeanServer != null && this.resourceDMBeans != null) {
            try {
                for (ResourceDMBean resourceDMBean : this.resourceDMBeans) {
                    ObjectName objectName = resourceDMBean.getObjectName();
                    if (objectName == null) continue;
                    this.unregisterMBean(objectName);
                }
                this.resourceDMBeans = null;
            }
            catch (Exception e) {
                throw new CacheException("Failure while unregistering MBeans", (Throwable)e);
            }
        }
    }

    protected abstract String initGroup();

    public final boolean enabled() {
        return this.mBeanServer != null;
    }

    public final String getDomain() {
        if (this.mBeanServer == null) {
            throw new IllegalStateException("MBean server not initialized");
        }
        return this.globalConfig.jmx().domain();
    }

    public final String getGroupName() {
        if (this.mBeanServer == null) {
            throw new IllegalStateException("MBean server not initialized");
        }
        return this.groupName;
    }

    public final MBeanServer getMBeanServer() {
        if (this.mBeanServer == null) {
            throw new IllegalStateException("MBean server not initialized");
        }
        return this.mBeanServer;
    }

    private static ObjectName getObjectName(String domain, String groupName, String resourceName) throws MalformedObjectNameException {
        if (domain == null) {
            throw new IllegalArgumentException("domain cannot be null");
        }
        if (groupName == null) {
            throw new IllegalArgumentException("groupName cannot be null");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("resourceName cannot be null");
        }
        return new ObjectName(domain + ":" + groupName + ",component=" + resourceName);
    }

    private ObjectName getObjectName(String groupName, String resourceName) throws MalformedObjectNameException {
        return AbstractJmxRegistration.getObjectName(this.getDomain(), groupName, resourceName);
    }

    private List<ResourceDMBean> getResourceDMBeansFromComponents() {
        Collection<ComponentRef<?>> components = this.basicComponentRegistry.getRegisteredComponents();
        ArrayList<ResourceDMBean> resourceDMBeans = new ArrayList<ResourceDMBean>(components.size());
        for (ComponentRef<?> component : components) {
            ResourceDMBean resourceDMBean;
            Object instance;
            if (component.isAlias() || (instance = component.wired()) == null || (resourceDMBean = this.getResourceDMBean(instance, component.getName())) == null) continue;
            if (this.mainComponent.equals(resourceDMBean.getMBeanName())) {
                resourceDMBeans.add(0, resourceDMBean);
                continue;
            }
            resourceDMBeans.add(resourceDMBean);
        }
        if (resourceDMBeans.isEmpty()) {
            throw new IllegalStateException("No MBeans found in component registry!");
        }
        return resourceDMBeans;
    }

    private ResourceDMBean getResourceDMBean(Object instance, String componentName) {
        MBeanMetadata beanMetadata = this.basicComponentRegistry.getMBeanMetadata(instance.getClass().getName());
        return beanMetadata == null ? null : new ResourceDMBean(instance, beanMetadata, componentName);
    }

    public ObjectName registerExternalMBean(Object managedComponent, String groupName) throws Exception {
        if (this.mBeanServer == null) {
            throw new IllegalStateException("MBean server not initialized");
        }
        ResourceDMBean resourceDMBean = this.getResourceDMBean(managedComponent, null);
        if (resourceDMBean == null) {
            throw new IllegalArgumentException("No MBean metadata found for " + managedComponent.getClass().getName());
        }
        ObjectName objectName = this.getObjectName(groupName, resourceDMBean.getMBeanName());
        this.register(resourceDMBean, objectName, this.mBeanServer);
        return objectName;
    }

    public void registerMBean(Object managedComponent) throws Exception {
        this.registerMBean(managedComponent, this.groupName);
    }

    public void registerMBean(Object managedComponent, String groupName) throws Exception {
        if (this.mBeanServer == null) {
            throw new IllegalStateException("MBean server not initialized");
        }
        ResourceDMBean resourceDMBean = this.getResourceDMBean(managedComponent, null);
        if (resourceDMBean == null) {
            throw new IllegalArgumentException("No MBean metadata found for " + managedComponent.getClass().getName());
        }
        ObjectName objectName = this.getObjectName(groupName, resourceDMBean.getMBeanName());
        this.register(resourceDMBean, objectName, this.mBeanServer);
        this.resourceDMBeans.add(resourceDMBean);
    }

    private void register(ResourceDMBean resourceDMBean, ObjectName objectName, MBeanServer mBeanServer) throws Exception {
        mBeanServer.registerMBean(resourceDMBean, objectName);
        if (log.isTraceEnabled()) {
            log.tracef("Registered MBean %s under %s", resourceDMBean, objectName);
        }
    }

    public void unregisterMBean(ObjectName objectName) throws Exception {
        if (this.mBeanServer.isRegistered(objectName)) {
            this.mBeanServer.unregisterMBean(objectName);
            if (log.isTraceEnabled()) {
                log.tracef("Unregistered MBean: %s", objectName);
            }
        } else {
            log.debugf("MBean not registered: %s", objectName);
        }
    }
}

