/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan;

import org.infinispan.commons.api.Lifecycle;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.RolePermissionMapper;

@InfinispanModule(name="core")
public class CoreModule
implements ModuleLifecycle {
    @Override
    public void cacheManagerStarted(GlobalComponentRegistry gcr) {
        gcr.getComponent(GlobalConfigurationManager.class).postStart();
        CoreModule.startLifecycleComponent(gcr, RolePermissionMapper.class, PrincipalRoleMapper.class);
    }

    @Override
    public void cacheManagerStopping(GlobalComponentRegistry gcr) {
        CoreModule.stopLifecycleComponent(gcr, RolePermissionMapper.class, PrincipalRoleMapper.class);
    }

    public static void startLifecycleComponent(GlobalComponentRegistry gcr, Class<?> ... klasses) {
        for (Class<?> klass : klasses) {
            ComponentStatus status = gcr.getCacheManager().getStatus();
            if (status.isStopping() || status.isTerminated()) break;
            Object obj = gcr.getComponent(klass);
            if (!(obj instanceof Lifecycle)) continue;
            Lifecycle l = (Lifecycle)obj;
            l.start();
        }
    }

    public static void stopLifecycleComponent(GlobalComponentRegistry gcr, Class<?> ... klasses) {
        for (Class<?> klass : klasses) {
            Object obj = gcr.getComponent(klass);
            if (!(obj instanceof Lifecycle)) continue;
            Lifecycle l = (Lifecycle)obj;
            l.stop();
        }
    }
}

