/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.multimap;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.Bucket;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.function.multimap.BaseFunction;

public final class RemoveFunction<K, V>
implements BaseFunction<K, V, Boolean> {
    public static final AdvancedExternalizer<RemoveFunction> EXTERNALIZER = new Externalizer();
    private final V value;
    private final boolean supportsDuplicates;

    public RemoveFunction() {
        this.value = null;
        this.supportsDuplicates = false;
    }

    public RemoveFunction(V value, boolean supportsDuplicates) {
        this.value = value;
        this.supportsDuplicates = supportsDuplicates;
    }

    public Boolean apply(EntryView.ReadWriteEntryView<K, Bucket<V>> entryView) {
        Boolean removed = this.value == null ? this.removeKey(entryView) : this.removeKeyValue(entryView);
        return removed;
    }

    private Boolean removeKeyValue(EntryView.ReadWriteEntryView<K, Bucket<V>> entryView) {
        return entryView.find().map(bucket -> {
            Bucket<V> newBucket = bucket.remove(this.value, this.supportsDuplicates);
            if (newBucket != null) {
                if (newBucket.isEmpty()) {
                    entryView.remove();
                } else {
                    entryView.set(newBucket, new MetaParam.Writable[0]);
                }
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }).orElse(Boolean.FALSE);
    }

    private Boolean removeKey(EntryView.ReadWriteEntryView<K, Bucket<V>> entryView) {
        return entryView.find().map(values -> {
            entryView.remove();
            return Boolean.TRUE;
        }).orElse(Boolean.FALSE);
    }

    private static class Externalizer
    implements AdvancedExternalizer<RemoveFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends RemoveFunction>> getTypeClasses() {
            return Collections.singleton(RemoveFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.REMOVE_KEY_VALUE_FUNCTION;
        }

        public void writeObject(ObjectOutput output, RemoveFunction object) throws IOException {
            output.writeObject(object.value);
            output.writeBoolean(object.supportsDuplicates);
        }

        public RemoveFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new RemoveFunction(input.readObject(), input.readBoolean());
        }
    }
}

