/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCertificate;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import com.microsoft.aad.msal4j.IntegratedWindowsAuthenticationParameters;
import com.microsoft.aad.msal4j.InteractiveRequestParameters;
import com.microsoft.aad.msal4j.MsalInteractionRequiredException;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.SilentParameters;
import com.microsoft.aad.msal4j.SystemBrowserOptions;
import com.microsoft.aad.msal4j.UserNamePasswordParameters;
import com.microsoft.sqlserver.jdbc.PersistentTokenCacheAccessAspect;
import com.microsoft.sqlserver.jdbc.SQLServerCertificateUtils;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResource;
import com.microsoft.sqlserver.jdbc.SqlAuthenticationToken;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.kerberos.KerberosPrincipal;

class SQLServerMSAL4JUtils {
    static final String REDIRECTURI = "http://localhost";
    static final String SLASH_DEFAULT = "/.default";
    static final String ACCESS_TOKEN_EXPIRE = "access token expires: ";
    private static final TokenCacheMap TOKEN_CACHE_MAP = new TokenCacheMap();
    private static final String LOGCONTEXT = "MSAL version " + PublicClientApplication.class.getPackage().getImplementationVersion() + ": ";
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerMSAL4JUtils");
    private static final Lock lock = new ReentrantLock();

    private SQLServerMSAL4JUtils() {
        throw new UnsupportedOperationException(SQLServerException.getErrString("R_notSupported"));
    }

    static SqlAuthenticationToken getSqlFedAuthToken(SQLServerConnection.SqlFedAuthInfo fedAuthInfo, String user, String password, String authenticationString) throws SQLServerException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(LOGCONTEXT + authenticationString + ": get FedAuth token for user: " + user);
        }
        lock.lock();
        try {
            String hashedSecret = Util.getHashedSecret(new String[]{fedAuthInfo.stsurl, user, password});
            PersistentTokenCacheAccessAspect persistentTokenCacheAccessAspect = TOKEN_CACHE_MAP.getEntry(user, hashedSecret);
            if (null == persistentTokenCacheAccessAspect) {
                persistentTokenCacheAccessAspect = new PersistentTokenCacheAccessAspect();
                TOKEN_CACHE_MAP.addEntry(hashedSecret, persistentTokenCacheAccessAspect);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(LOGCONTEXT + ": cache token for user: " + user);
                }
            } else if (logger.isLoggable(Level.FINER)) {
                logger.finer(LOGCONTEXT + ": retrieved cached token for user: " + user);
            }
            PublicClientApplication pca = ((PublicClientApplication.Builder)((PublicClientApplication.Builder)((PublicClientApplication.Builder)PublicClientApplication.builder((String)"7f98cb04-cd1e-40df-9140-3bf7e2cea4db").executorService(executorService)).setTokenCacheAccessAspect((ITokenCacheAccessAspect)persistentTokenCacheAccessAspect)).authority(fedAuthInfo.stsurl)).build();
            CompletableFuture future = pca.acquireToken(UserNamePasswordParameters.builder(Collections.singleton(fedAuthInfo.spn + SLASH_DEFAULT), (String)user, (char[])password.toCharArray()).build());
            IAuthenticationResult authenticationResult = (IAuthenticationResult)future.get();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(LOGCONTEXT + (authenticationResult.account() != null ? authenticationResult.account().username() + ": " : ACCESS_TOKEN_EXPIRE + authenticationResult.expiresOnDate()));
            }
            SqlAuthenticationToken sqlAuthenticationToken = new SqlAuthenticationToken(authenticationResult.accessToken(), authenticationResult.expiresOnDate());
            return sqlAuthenticationToken;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLServerException(e.getMessage(), e);
        }
        catch (MalformedURLException | ExecutionException e) {
            throw SQLServerMSAL4JUtils.getCorrectedException(e, user, authenticationString);
        }
        finally {
            lock.unlock();
            executorService.shutdown();
        }
    }

    static SqlAuthenticationToken getSqlFedAuthTokenPrincipal(SQLServerConnection.SqlFedAuthInfo fedAuthInfo, String aadPrincipalID, String aadPrincipalSecret, String authenticationString) throws SQLServerException {
        String defaultScopeSuffix;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(LOGCONTEXT + authenticationString + ": get FedAuth token for principal: " + aadPrincipalID);
        }
        String scope = fedAuthInfo.spn.endsWith(defaultScopeSuffix = SLASH_DEFAULT) ? fedAuthInfo.spn : fedAuthInfo.spn + defaultScopeSuffix;
        HashSet<String> scopes = new HashSet<String>();
        scopes.add(scope);
        lock.lock();
        try {
            String hashedSecret = Util.getHashedSecret(new String[]{fedAuthInfo.stsurl, aadPrincipalID, aadPrincipalSecret});
            PersistentTokenCacheAccessAspect persistentTokenCacheAccessAspect = TOKEN_CACHE_MAP.getEntry(aadPrincipalID, hashedSecret);
            if (null == persistentTokenCacheAccessAspect) {
                persistentTokenCacheAccessAspect = new PersistentTokenCacheAccessAspect();
                TOKEN_CACHE_MAP.addEntry(hashedSecret, persistentTokenCacheAccessAspect);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(LOGCONTEXT + ": cache token for principal id: " + aadPrincipalID);
                }
            } else if (logger.isLoggable(Level.FINER)) {
                logger.finer(LOGCONTEXT + ": retrieved cached token for principal id: " + aadPrincipalID);
            }
            IClientSecret credential = ClientCredentialFactory.createFromSecret((String)aadPrincipalSecret);
            ConfidentialClientApplication clientApplication = ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)aadPrincipalID, (IClientCredential)credential).executorService(executorService)).setTokenCacheAccessAspect((ITokenCacheAccessAspect)persistentTokenCacheAccessAspect)).authority(fedAuthInfo.stsurl)).build();
            CompletableFuture future = clientApplication.acquireToken(ClientCredentialParameters.builder(scopes).build());
            IAuthenticationResult authenticationResult = (IAuthenticationResult)future.get();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(LOGCONTEXT + (authenticationResult.account() != null ? authenticationResult.account().username() + ": " : ACCESS_TOKEN_EXPIRE + authenticationResult.expiresOnDate()));
            }
            SqlAuthenticationToken sqlAuthenticationToken = new SqlAuthenticationToken(authenticationResult.accessToken(), authenticationResult.expiresOnDate());
            return sqlAuthenticationToken;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLServerException(e.getMessage(), e);
        }
        catch (MalformedURLException | ExecutionException e) {
            throw SQLServerMSAL4JUtils.getCorrectedException(e, aadPrincipalID, authenticationString);
        }
        finally {
            lock.unlock();
            executorService.shutdown();
        }
    }

    static SqlAuthenticationToken getSqlFedAuthTokenPrincipalCertificate(SQLServerConnection.SqlFedAuthInfo fedAuthInfo, String aadPrincipalID, String certFile, String certPassword, String certKey, String certKeyPassword, String authenticationString) throws SQLServerException {
        String defaultScopeSuffix;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(LOGCONTEXT + authenticationString + ": get FedAuth token for principal certificate: " + aadPrincipalID);
        }
        String scope = fedAuthInfo.spn.endsWith(defaultScopeSuffix = SLASH_DEFAULT) ? fedAuthInfo.spn : fedAuthInfo.spn + defaultScopeSuffix;
        HashSet<String> scopes = new HashSet<String>();
        scopes.add(scope);
        lock.lock();
        try {
            IClientCertificate credential;
            ConfidentialClientApplication clientApplication;
            PersistentTokenCacheAccessAspect persistentTokenCacheAccessAspect;
            block25: {
                String hashedSecret = Util.getHashedSecret(new String[]{fedAuthInfo.stsurl, aadPrincipalID, certFile, certPassword, certKey, certKeyPassword});
                persistentTokenCacheAccessAspect = TOKEN_CACHE_MAP.getEntry(aadPrincipalID, hashedSecret);
                if (null == persistentTokenCacheAccessAspect) {
                    persistentTokenCacheAccessAspect = new PersistentTokenCacheAccessAspect();
                    TOKEN_CACHE_MAP.addEntry(hashedSecret, persistentTokenCacheAccessAspect);
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer(LOGCONTEXT + ": cache token for principal id: " + aadPrincipalID);
                    }
                } else if (logger.isLoggable(Level.FINER)) {
                    logger.finer(LOGCONTEXT + ": retrieved cached token for principal id: " + aadPrincipalID);
                }
                clientApplication = null;
                try (FileInputStream is = new FileInputStream(certFile);){
                    KeyStore keyStore = SQLServerCertificateUtils.loadPKCS12KeyStore(certFile, certPassword);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(LOGCONTEXT + "certificate type: " + keyStore.getType());
                        Enumeration<String> enumeration = keyStore.aliases();
                        while (enumeration.hasMoreElements()) {
                            String alias = enumeration.nextElement();
                            X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
                            cert.checkValidity();
                            logger.finest(LOGCONTEXT + "certificate: " + cert.toString());
                        }
                    }
                    credential = ClientCredentialFactory.createFromCertificate((InputStream)is, (String)certPassword);
                    clientApplication = ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)aadPrincipalID, (IClientCredential)credential).executorService(executorService)).setTokenCacheAccessAspect((ITokenCacheAccessAspect)persistentTokenCacheAccessAspect)).authority(fedAuthInfo.stsurl)).build();
                }
                catch (FileNotFoundException e) {
                    throw new SQLServerException(SQLServerException.getErrString("R_readCertError") + e.getMessage(), null, 0, null);
                }
                catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                    if (!logger.isLoggable(Level.FINER)) break block25;
                    logger.finer(LOGCONTEXT + "Error loading PKCS12 certificate: " + e.getMessage());
                }
            }
            if (clientApplication == null) {
                X509Certificate cert = (X509Certificate)SQLServerCertificateUtils.loadCertificate(certFile);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(LOGCONTEXT + "certificate type: " + cert.getType());
                    cert.checkValidity();
                    logger.finer(LOGCONTEXT + "certificate: " + cert.toString());
                }
                PrivateKey privateKey = SQLServerCertificateUtils.loadPrivateKey(certKey, certKeyPassword);
                credential = ClientCredentialFactory.createFromCertificate((PrivateKey)privateKey, (X509Certificate)cert);
                clientApplication = ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)aadPrincipalID, (IClientCredential)credential).executorService(executorService)).setTokenCacheAccessAspect((ITokenCacheAccessAspect)persistentTokenCacheAccessAspect)).authority(fedAuthInfo.stsurl)).build();
            }
            CompletableFuture future = clientApplication.acquireToken(ClientCredentialParameters.builder(scopes).build());
            IAuthenticationResult authenticationResult = (IAuthenticationResult)future.get();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(LOGCONTEXT + (authenticationResult.account() != null ? authenticationResult.account().username() + ": " : ACCESS_TOKEN_EXPIRE + authenticationResult.expiresOnDate()));
            }
            SqlAuthenticationToken sqlAuthenticationToken = new SqlAuthenticationToken(authenticationResult.accessToken(), authenticationResult.expiresOnDate());
            return sqlAuthenticationToken;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLServerException(e.getMessage(), e);
        }
        catch (GeneralSecurityException e) {
            throw new SQLServerException(SQLServerException.getErrString("R_readCertError") + e.getMessage(), null, 0, null);
        }
        catch (Exception e) {
            throw SQLServerMSAL4JUtils.getCorrectedException(e, aadPrincipalID, authenticationString);
        }
        finally {
            lock.unlock();
            executorService.shutdown();
        }
    }

    static SqlAuthenticationToken getSqlFedAuthTokenIntegrated(SQLServerConnection.SqlFedAuthInfo fedAuthInfo, String authenticationString) throws SQLServerException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        KerberosPrincipal kerberosPrincipal = new KerberosPrincipal("username");
        String user = kerberosPrincipal.getName();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(LOGCONTEXT + authenticationString + ": get FedAuth token integrated, user: " + user + "realm name:" + kerberosPrincipal.getRealm());
        }
        lock.lock();
        try {
            PublicClientApplication pca = ((PublicClientApplication.Builder)((PublicClientApplication.Builder)((PublicClientApplication.Builder)PublicClientApplication.builder((String)"7f98cb04-cd1e-40df-9140-3bf7e2cea4db").executorService(executorService)).setTokenCacheAccessAspect((ITokenCacheAccessAspect)PersistentTokenCacheAccessAspect.getInstance())).authority(fedAuthInfo.stsurl)).build();
            CompletableFuture future = pca.acquireToken(IntegratedWindowsAuthenticationParameters.builder(Collections.singleton(fedAuthInfo.spn + SLASH_DEFAULT), (String)user).build());
            IAuthenticationResult authenticationResult = (IAuthenticationResult)future.get();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(LOGCONTEXT + (authenticationResult.account() != null ? authenticationResult.account().username() + ": " : ACCESS_TOKEN_EXPIRE + authenticationResult.expiresOnDate()));
            }
            SqlAuthenticationToken sqlAuthenticationToken = new SqlAuthenticationToken(authenticationResult.accessToken(), authenticationResult.expiresOnDate());
            return sqlAuthenticationToken;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLServerException(e.getMessage(), e);
        }
        catch (IOException | ExecutionException e) {
            throw SQLServerMSAL4JUtils.getCorrectedException(e, user, authenticationString);
        }
        finally {
            lock.unlock();
            executorService.shutdown();
        }
    }

    static SqlAuthenticationToken getSqlFedAuthTokenInteractive(SQLServerConnection.SqlFedAuthInfo fedAuthInfo, String user, String authenticationString) throws SQLServerException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(LOGCONTEXT + authenticationString + ": get FedAuth token interactive for user: " + user);
        }
        lock.lock();
        try {
            IAuthenticationResult authenticationResult;
            CompletableFuture future;
            PublicClientApplication pca;
            block20: {
                pca = ((PublicClientApplication.Builder)((PublicClientApplication.Builder)((PublicClientApplication.Builder)PublicClientApplication.builder((String)"7f98cb04-cd1e-40df-9140-3bf7e2cea4db").executorService(executorService)).setTokenCacheAccessAspect((ITokenCacheAccessAspect)PersistentTokenCacheAccessAspect.getInstance())).authority(fedAuthInfo.stsurl)).build();
                future = null;
                authenticationResult = null;
                try {
                    IAccount account;
                    Set accountsInCache = (Set)pca.getAccounts().join();
                    if (logger.isLoggable(Level.FINEST)) {
                        StringBuilder acc = new StringBuilder();
                        if (accountsInCache != null) {
                            for (IAccount account2 : accountsInCache) {
                                if (acc.length() != 0) {
                                    acc.append(", ");
                                }
                                acc.append(account2.username());
                            }
                        }
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(LOGCONTEXT + "Accounts in cache = " + acc + ", size = " + (accountsInCache == null ? null : Integer.valueOf(accountsInCache.size())) + ", user = " + user);
                        }
                    }
                    if (null != accountsInCache && !accountsInCache.isEmpty() && null != user && !user.isEmpty() && null != (account = SQLServerMSAL4JUtils.getAccountByUsername(accountsInCache, user))) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(LOGCONTEXT + "Silent authentication for user:" + user);
                        }
                        SilentParameters silentParameters = SilentParameters.builder(Collections.singleton(fedAuthInfo.spn + SLASH_DEFAULT), (IAccount)account).build();
                        future = pca.acquireTokenSilently(silentParameters);
                    }
                }
                catch (MsalInteractionRequiredException e) {
                    if (!logger.isLoggable(Level.FINEST)) break block20;
                    logger.log(Level.FINEST, e, () -> LOGCONTEXT + "Need to get token interactively: " + e.reason().toString());
                }
            }
            if (null != future) {
                authenticationResult = (IAuthenticationResult)future.get();
            } else {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(LOGCONTEXT + "Interactive authentication");
                }
                InteractiveRequestParameters parameters = InteractiveRequestParameters.builder((URI)new URI(REDIRECTURI)).systemBrowserOptions(SystemBrowserOptions.builder().htmlMessageSuccess(SQLServerResource.getResource("R_MSALAuthComplete")).build()).loginHint(user).scopes(Collections.singleton(fedAuthInfo.spn + SLASH_DEFAULT)).build();
                future = pca.acquireToken(parameters);
                authenticationResult = (IAuthenticationResult)future.get();
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(LOGCONTEXT + (authenticationResult.account() != null ? authenticationResult.account().username() + ": " : ACCESS_TOKEN_EXPIRE + authenticationResult.expiresOnDate()));
            }
            SqlAuthenticationToken sqlAuthenticationToken = new SqlAuthenticationToken(authenticationResult.accessToken(), authenticationResult.expiresOnDate());
            return sqlAuthenticationToken;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLServerException(e.getMessage(), e);
        }
        catch (MalformedURLException | URISyntaxException | ExecutionException e) {
            throw SQLServerMSAL4JUtils.getCorrectedException(e, user, authenticationString);
        }
        finally {
            lock.unlock();
            executorService.shutdown();
        }
    }

    private static IAccount getAccountByUsername(Set<IAccount> accounts, String username) {
        if (!accounts.isEmpty()) {
            for (IAccount account : accounts) {
                if (!account.username().equalsIgnoreCase(username)) continue;
                return account;
            }
        }
        return null;
    }

    private static SQLServerException getCorrectedException(Exception e, String user, String authenticationString) {
        Object[] msgArgs = new Object[]{user, authenticationString};
        if (null == e.getCause() || null == e.getCause().getMessage()) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_MSALExecution") + " " + e.getMessage());
            return new SQLServerException(form.format(msgArgs), null);
        }
        String correctedErrorMessage = e.getCause().getMessage().replaceAll("\\\\r\\\\n", "\r\n").replaceAll("\\{", "\"").replaceAll("\\}", "\"");
        RuntimeException correctedAuthenticationException = new RuntimeException(correctedErrorMessage);
        MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_MSALExecution") + " " + correctedErrorMessage);
        ExecutionException correctedExecutionException = new ExecutionException(correctedAuthenticationException);
        return new SQLServerException(form.format(msgArgs), null, 0, (Throwable)correctedExecutionException);
    }

    private static class TokenCacheMap {
        private ConcurrentHashMap<String, PersistentTokenCacheAccessAspect> tokenCacheMap = new ConcurrentHashMap();

        private TokenCacheMap() {
        }

        PersistentTokenCacheAccessAspect getEntry(String value, String key) {
            long currentTime;
            PersistentTokenCacheAccessAspect persistentTokenCacheAccessAspect = this.tokenCacheMap.get(key);
            if (null != persistentTokenCacheAccessAspect && (currentTime = System.currentTimeMillis()) > persistentTokenCacheAccessAspect.getExpiryTime()) {
                this.tokenCacheMap.remove(key);
                persistentTokenCacheAccessAspect = new PersistentTokenCacheAccessAspect();
                persistentTokenCacheAccessAspect.setExpiryTime(currentTime + 86400000L);
                this.tokenCacheMap.put(key, persistentTokenCacheAccessAspect);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(LOGCONTEXT + ": entry expired for: " + value + " new entry will expire in: " + TimeUnit.MILLISECONDS.toSeconds(86400000L) + "s");
                }
            }
            return persistentTokenCacheAccessAspect;
        }

        void addEntry(String key, PersistentTokenCacheAccessAspect value) {
            value.setExpiryTime(System.currentTimeMillis() + 86400000L);
            this.tokenCacheMap.put(key, value);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(LOGCONTEXT + ": add entry for: " + value + ", will expire in: " + TimeUnit.MILLISECONDS.toSeconds(86400000L) + "s");
            }
        }
    }
}

