/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import twitter4j.Authorization;
import twitter4j.HttpParameter;
import twitter4j.RequestMethod;

final class HttpRequest
implements Serializable {
    private static final long serialVersionUID = 3365496352032493020L;
    private final RequestMethod method;
    private final String url;
    private final HttpParameter[] parameters;
    private final Authorization authorization;
    private final Map<String, String> requestHeaders;
    private static final HttpParameter[] NULL_PARAMETERS = new HttpParameter[0];

    public HttpRequest(RequestMethod method, String url, HttpParameter[] parameters, Authorization authorization, Map<String, String> requestHeaders) {
        this.method = method;
        if (method != RequestMethod.POST && parameters != null && parameters.length != 0) {
            this.url = url + "?" + HttpParameter.encodeParameters(parameters);
            this.parameters = NULL_PARAMETERS;
        } else {
            this.url = url;
            this.parameters = parameters;
        }
        this.authorization = authorization;
        this.requestHeaders = requestHeaders;
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public HttpParameter[] getParameters() {
        return this.parameters;
    }

    public String getURL() {
        return this.url;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequest that = (HttpRequest)o;
        if (!Objects.equals(this.authorization, that.authorization)) {
            return false;
        }
        if (!Arrays.equals(this.parameters, that.parameters)) {
            return false;
        }
        if (!Objects.equals(this.requestHeaders, that.requestHeaders)) {
            return false;
        }
        if (!Objects.equals((Object)this.method, (Object)that.method)) {
            return false;
        }
        return Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? Arrays.hashCode(this.parameters) : 0);
        result = 31 * result + (this.authorization != null ? this.authorization.hashCode() : 0);
        result = 31 * result + (this.requestHeaders != null ? this.requestHeaders.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HttpRequest{requestMethod=" + (Object)((Object)this.method) + ", url='" + this.url + '\'' + ", postParams=" + (this.parameters == null ? null : Arrays.asList(this.parameters)) + ", authentication=" + this.authorization + ", requestHeaders=" + this.requestHeaders + '}';
    }
}

