/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.dblock;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.dblock.DBLockProvider;
import org.keycloak.models.dblock.DBLockProviderFactory;

public class DBLockManager {
    protected static final Logger logger = Logger.getLogger(DBLockManager.class);
    private final KeycloakSession session;

    public DBLockManager(KeycloakSession session) {
        this.session = session;
    }

    public void checkForcedUnlock() {
        if (Boolean.getBoolean("keycloak.dblock.forceUnlock")) {
            DBLockProvider lock = this.getDBLock();
            if (lock.supportsForcedUnlock()) {
                logger.warn((Object)"Forced release of DB lock at startup requested by System property. Make sure to not use this in production environment! And especially when more cluster nodes are started concurrently.");
                lock.releaseLock();
            } else {
                throw new IllegalStateException("Forced unlock requested, but provider " + String.valueOf(lock) + " doesn't support it");
            }
        }
    }

    public DBLockProvider getDBLock() {
        return (DBLockProvider)this.session.getProvider(DBLockProvider.class);
    }

    public DBLockProviderFactory getDBLockFactory() {
        return (DBLockProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(DBLockProvider.class);
    }
}

