/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.namednumber.IpV6NeighborDiscoveryOptionType;
import org.pcap4j.util.ByteArrays;

public final class UnknownIpV6NeighborDiscoveryOption
implements IcmpV6CommonPacket.IpV6NeighborDiscoveryOption {
    private static final long serialVersionUID = -5097068268518944469L;
    private final IpV6NeighborDiscoveryOptionType type;
    private final byte length;
    private final byte[] data;

    public static UnknownIpV6NeighborDiscoveryOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new UnknownIpV6NeighborDiscoveryOption(rawData, offset, length);
    }

    private UnknownIpV6NeighborDiscoveryOption(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 2) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The raw data length must be more than 1. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.type = IpV6NeighborDiscoveryOptionType.getInstance(rawData[offset]);
        this.length = rawData[1 + offset];
        if (length < this.length * 8) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The raw data is too short to build this option(").append(this.length * 8).append("). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.data = ByteArrays.getSubArray(rawData, 2 + offset, this.length * 8 - 2);
    }

    private UnknownIpV6NeighborDiscoveryOption(Builder builder2) {
        if (builder2 == null || builder2.type == null || builder2.data == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.type: ").append(builder2.type).append(" builder.data: ").append(builder2.data);
            throw new NullPointerException(sb.toString());
        }
        this.type = builder2.type;
        this.data = new byte[builder2.data.length];
        System.arraycopy(builder2.data, 0, this.data, 0, builder2.data.length);
        this.length = builder2.correctLengthAtBuild ? (byte)this.length() : builder2.length;
    }

    @Override
    public IpV6NeighborDiscoveryOptionType getType() {
        return this.type;
    }

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    public byte[] getData() {
        byte[] copy = new byte[this.data.length];
        System.arraycopy(this.data, 0, copy, 0, this.data.length);
        return copy;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.type.value();
        rawData[1] = this.length;
        System.arraycopy(this.data, 0, rawData, 2, this.data.length);
        return rawData;
    }

    @Override
    public int length() {
        return this.data.length + 2;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Type: ").append(this.type).append("] [Length: ").append(this.getLengthAsInt()).append(" bytes] [Data: 0x").append(ByteArrays.toHexString(this.data, "")).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        UnknownIpV6NeighborDiscoveryOption other = (UnknownIpV6NeighborDiscoveryOption)obj;
        return this.type.equals(other.type) && this.length == other.length && Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.length;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public static final class Builder
    implements LengthBuilder<UnknownIpV6NeighborDiscoveryOption> {
        private IpV6NeighborDiscoveryOptionType type;
        private byte length;
        private byte[] data;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        private Builder(UnknownIpV6NeighborDiscoveryOption option) {
            this.type = option.type;
            this.length = option.length;
            this.data = option.data;
        }

        public Builder type(IpV6NeighborDiscoveryOptionType type) {
            this.type = type;
            return this;
        }

        public Builder length(byte length) {
            this.length = length;
            return this;
        }

        public Builder data(byte[] data) {
            this.data = data;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public UnknownIpV6NeighborDiscoveryOption build() {
            return new UnknownIpV6NeighborDiscoveryOption(this);
        }
    }
}

