/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LlcPacket;
import org.pcap4j.packet.namednumber.LlcControlSupervisoryFunction;
import org.pcap4j.util.ByteArrays;

public final class LlcControlSupervisory
implements LlcPacket.LlcControl {
    private static final long serialVersionUID = 2248935134729569341L;
    private final byte receiveSequenceNumber;
    private final boolean pfBit;
    private final byte reserved;
    private final LlcControlSupervisoryFunction supervisoryFunction;

    public static LlcControlSupervisory newInstance(short value2) throws IllegalRawDataException {
        return new LlcControlSupervisory(value2);
    }

    private LlcControlSupervisory(short value2) throws IllegalRawDataException {
        if ((value2 & 0x300) != 256) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("value & 0x0300 must be 0x0100. value: ").append(ByteArrays.toHexString(value2, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        this.receiveSequenceNumber = (byte)(value2 >> 1 & 0x7F);
        this.pfBit = (value2 & 1) != 0;
        this.reserved = (byte)(value2 >> 12 & 0xF);
        this.supervisoryFunction = LlcControlSupervisoryFunction.getInstance((byte)(value2 >> 10 & 3));
    }

    private LlcControlSupervisory(Builder builder2) {
        if (builder2 == null || builder2.supervisoryFunction == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.supervisoryFunction: ").append(builder2.supervisoryFunction);
            throw new NullPointerException(sb.toString());
        }
        if (builder2.receiveSequenceNumber < 0) {
            throw new IllegalArgumentException("receiveSequenceNumber must be positive. receiveSequenceNumber: " + builder2.receiveSequenceNumber);
        }
        if ((builder2.reserved & 0xFF00) != 0) {
            throw new IllegalArgumentException("reserved & 0xFF00 must be 0. reserved: " + builder2.reserved);
        }
        this.receiveSequenceNumber = builder2.receiveSequenceNumber;
        this.pfBit = builder2.pfBit;
        this.reserved = builder2.reserved;
        this.supervisoryFunction = builder2.supervisoryFunction;
    }

    public byte getReceiveSequenceNumber() {
        return this.receiveSequenceNumber;
    }

    public int getReceiveSequenceNumberAsInt() {
        return this.receiveSequenceNumber;
    }

    public boolean getPfBit() {
        return this.pfBit;
    }

    public byte getReserved() {
        return this.reserved;
    }

    public LlcControlSupervisoryFunction getLlcSupervisoryFunction() {
        return this.supervisoryFunction;
    }

    @Override
    public int length() {
        return 2;
    }

    @Override
    public byte[] getRawData() {
        byte[] data = new byte[2];
        data[1] = (byte)(this.receiveSequenceNumber << 1);
        if (this.pfBit) {
            data[1] = (byte)(data[1] | 1);
        }
        data[0] = (byte)(1 | (Byte)this.supervisoryFunction.value() << 2 | this.reserved << 4);
        return data;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[receive sequence number: ").append(this.receiveSequenceNumber).append("] [P/F bit: ").append(this.pfBit ? 1 : 0).append("] [reserved: ").append(this.reserved).append("] [supervisory function: ").append(this.supervisoryFunction).append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.receiveSequenceNumber;
        result = 31 * result + (this.pfBit ? 1231 : 1237);
        result = 31 * result + this.reserved;
        result = 31 * result + this.supervisoryFunction.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        LlcControlSupervisory other = (LlcControlSupervisory)obj;
        return this.receiveSequenceNumber == other.receiveSequenceNumber && this.supervisoryFunction.equals(other.supervisoryFunction) && this.reserved == other.reserved && this.pfBit == other.pfBit;
    }

    public static final class Builder {
        private byte receiveSequenceNumber;
        private boolean pfBit;
        private byte reserved;
        private LlcControlSupervisoryFunction supervisoryFunction;

        public Builder() {
        }

        private Builder(LlcControlSupervisory ctrl) {
            this.receiveSequenceNumber = ctrl.receiveSequenceNumber;
            this.pfBit = ctrl.pfBit;
            this.reserved = ctrl.reserved;
            this.supervisoryFunction = ctrl.supervisoryFunction;
        }

        public Builder receiveSequenceNumber(byte receiveSequenceNumber) {
            this.receiveSequenceNumber = receiveSequenceNumber;
            return this;
        }

        public Builder pfBit(boolean pfBit) {
            this.pfBit = pfBit;
            return this;
        }

        public Builder reserved(byte reserved) {
            this.reserved = reserved;
            return this;
        }

        public Builder supervisoryFunction(LlcControlSupervisoryFunction supervisoryFunction) {
            this.supervisoryFunction = supervisoryFunction;
            return this;
        }

        public LlcControlSupervisory build() {
            return new LlcControlSupervisory(this);
        }
    }
}

